/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.jaxrs.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.domain.money.Money;

public abstract class JacksonReaderWriterProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private final ObjectMapper objectMapper;
    protected boolean supportsArrays;
    protected boolean supportsEnums;
    protected boolean supportsPrimitives;
    private final List<Class<?>> supportedTypes = new ArrayList();
    private final List<MediaType> mediaTypes = new ArrayList<MediaType>();

    public JacksonReaderWriterProvider(ObjectMapper objectMapper, MediaType mediaType) {
        this(objectMapper, Collections.singletonList(mediaType));
    }

    public JacksonReaderWriterProvider(ObjectMapper objectMapper, Collection<MediaType> mediaTypes) {
        this.objectMapper = objectMapper;
        this.mediaTypes.addAll(mediaTypes);
        this.supportsArrays = true;
        this.supportsEnums = true;
        this.supportsPrimitives = true;
        this.supportedTypes.add(String.class);
        this.supportedTypes.add(Number.class);
        this.supportedTypes.add(Collection.class);
        this.supportedTypes.add(Boolean.class);
        this.supportedTypes.add(Character.class);
        this.supportedTypes.add(Money.class);
        this.supportedTypes.add(ZonedDateTime.class);
        this.supportedTypes.add(Duration.class);
        this.supportedTypes.add(Instant.class);
        this.supportedTypes.add(LocalDateTime.class);
        this.supportedTypes.add(LocalDate.class);
        this.supportedTypes.add(LocalTime.class);
        this.supportedTypes.add(Period.class);
        try {
            this.supportedTypes.add(Class.forName("org.joda.time.DateMidnight"));
            this.supportedTypes.add(Class.forName("org.joda.time.DateTime"));
            this.supportedTypes.add(Class.forName("org.joda.time.Duration"));
            this.supportedTypes.add(Class.forName("org.joda.time.Instant"));
            this.supportedTypes.add(Class.forName("org.joda.time.LocalDateTime"));
            this.supportedTypes.add(Class.forName("org.joda.time.LocalDate"));
            this.supportedTypes.add(Class.forName("org.joda.time.LocalTime"));
            this.supportedTypes.add(Class.forName("org.joda.time.Period"));
            this.supportedTypes.add(Class.forName("org.joda.time.ReadableDateTime"));
            this.supportedTypes.add(Class.forName("org.joda.time.ReadableInstant"));
            this.supportedTypes.add(Class.forName("org.joda.time.Interval"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public JacksonReaderWriterProvider(ObjectMapper objectMapper, Collection<Class<?>> supportedTypes, Collection<MediaType> mediaTypes, boolean supportsArrays, boolean supportsEnums, boolean supportsPrimitives) {
        this.objectMapper = objectMapper;
        this.supportsArrays = supportsArrays;
        this.supportsEnums = supportsEnums;
        this.supportsPrimitives = supportsPrimitives;
        this.supportedTypes.addAll(supportedTypes);
    }

    public final void addSupportedType(Class type) {
        this.supportedTypes.add(type);
    }

    public final void addMediaType(MediaType type) {
        this.mediaTypes.add(type);
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> map, InputStream stream) throws IOException, WebApplicationException {
        String json = IoUtils.toString((InputStream)stream);
        return (T)this.objectMapper.readValue(json, type);
    }

    public void writeTo(T value, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> map, OutputStream stream) throws IOException, WebApplicationException {
        String json = this.objectMapper.writeValueAsString(value);
        stream.write(json.getBytes());
    }

    public final boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isSupported(type, mediaType);
    }

    public final boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isSupported(type, mediaType);
    }

    protected boolean isSupported(Class<?> type, MediaType mediaType) {
        if (!this.mediaTypes.contains(mediaType)) {
            return false;
        }
        if (type.isArray() && !this.supportsArrays) {
            return false;
        }
        if (type.isPrimitive() && !this.supportsPrimitives) {
            return false;
        }
        if (type.isEnum() && !this.supportsEnums) {
            return false;
        }
        if (type.isArray()) {
            type = type.getComponentType();
        }
        for (Class<?> supportedType : this.supportedTypes) {
            if (!supportedType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }
}

