/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import org.tiogasolutions.dev.common.fine.FineMessage;
import org.tiogasolutions.dev.common.fine.FineMessageSet;
import org.tiogasolutions.dev.common.fine.TraitMap;
import org.tiogasolutions.dev.domain.account.AccountStatus;
import org.tiogasolutions.dev.domain.locality.LatLng;
import org.tiogasolutions.dev.domain.money.Money;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.dev.jackson.mixins.AccountStatusMixin;
import org.tiogasolutions.dev.jackson.mixins.LatLngMixin;
import org.tiogasolutions.dev.jackson.money.TiogaMoneyDeserializer;
import org.tiogasolutions.dev.jackson.money.TiogaMoneySerializer;
import org.tiogasolutions.dev.jackson.msg.FineMessageMixin;
import org.tiogasolutions.dev.jackson.msg.FineMessageSetDeserializer;
import org.tiogasolutions.dev.jackson.msg.FineMessageSetSerializer;
import org.tiogasolutions.dev.jackson.qry.QueryResultDeserializer;
import org.tiogasolutions.dev.jackson.qry.QueryResultSerializer;
import org.tiogasolutions.dev.jackson.time.LocalDateDeserializer;
import org.tiogasolutions.dev.jackson.time.LocalDateSerializer;
import org.tiogasolutions.dev.jackson.time.LocalDateTimeDeserializer;
import org.tiogasolutions.dev.jackson.time.LocalDateTimeSerializer;
import org.tiogasolutions.dev.jackson.time.LocalTimeDeserializer;
import org.tiogasolutions.dev.jackson.time.LocalTimeSerializer;
import org.tiogasolutions.dev.jackson.time.ZonedDateTimeDeserializer;
import org.tiogasolutions.dev.jackson.time.ZonedDateTimeSerializer;
import org.tiogasolutions.dev.jackson.trait.TraitMapDeserializer;
import org.tiogasolutions.dev.jackson.trait.TraitMapSerializer;

public class TiogaJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public TiogaJacksonModule() {
        this.add((Class)Money.class, (JsonSerializer)new TiogaMoneySerializer(), (Class)Money.class, (JsonDeserializer)new TiogaMoneyDeserializer());
        this.add((Class)TraitMap.class, (JsonSerializer)new TraitMapSerializer(), (Class)TraitMap.class, (JsonDeserializer)new TraitMapDeserializer());
        this.add((Class)FineMessageSet.class, (JsonSerializer)new FineMessageSetSerializer(), (Class)FineMessageSet.class, (JsonDeserializer)new FineMessageSetDeserializer());
        this.add((Class)QueryResult.class, (JsonSerializer)new QueryResultSerializer(), (Class)QueryResult.class, (JsonDeserializer)new QueryResultDeserializer());
        this.add((Class)LocalDate.class, (JsonSerializer)new LocalDateSerializer(), (Class)LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
        this.add((Class)LocalTime.class, (JsonSerializer)new LocalTimeSerializer(), (Class)LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer());
        this.add((Class)LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(), (Class)LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        this.add((Class)ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer(), (Class)ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer());
        this.setMixInAnnotation(LatLng.class, LatLngMixin.class);
        this.setMixInAnnotation(FineMessage.class, FineMessageMixin.class);
        this.setMixInAnnotation(AccountStatus.class, AccountStatusMixin.class);
        this.add("org.joda.money.Money", "org.tiogasolutions.lib.joda.jackson.JodaMoneySerializer", "org.tiogasolutions.lib.joda.jackson.JodaMoneyDeserializer");
        this.add("org.joda.time.DateMidnight", "com.fasterxml.jackson.datatype.joda.ser.DateMidnightSerializer", "com.fasterxml.jackson.datatype.joda.deser.DateMidnightDeserializer");
        this.add("org.joda.time.DateTime", "com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer", "com.fasterxml.jackson.datatype.joda.deser.DateTimeDeserializer");
        this.add("org.joda.time.DateTimeZone", "com.fasterxml.jackson.datatype.joda.ser.DateTimeZoneSerializer", "com.fasterxml.jackson.datatype.joda.deser.DateTimeZoneDeserializer");
        this.add("org.joda.time.Duration", "com.fasterxml.jackson.datatype.joda.ser.DurationSerializer", "com.fasterxml.jackson.datatype.joda.deser.DurationDeserializer");
        this.add("org.joda.time.Instant", "com.fasterxml.jackson.datatype.joda.ser.InstantSerializer", "com.fasterxml.jackson.datatype.joda.deser.InstantDeserializer");
        this.add("org.joda.time.LocalDateTime", "com.fasterxml.jackson.datatype.joda.ser.LocalDateTimeSerializer", "com.fasterxml.jackson.datatype.joda.deser.LocalDateTimeDeserializer");
        this.add("org.joda.time.LocalDate", "com.fasterxml.jackson.datatype.joda.ser.LocalDateSerializer", "com.fasterxml.jackson.datatype.joda.deser.LocalDateDeserializer");
        this.add("org.joda.time.LocalTime", "com.fasterxml.jackson.datatype.joda.ser.LocalTimeSerializer", "com.fasterxml.jackson.datatype.joda.deser.LocalTimeDeserializer");
        this.add("org.joda.time.Period", "com.fasterxml.jackson.datatype.joda.ser.PeriodSerializer", "com.fasterxml.jackson.datatype.joda.deser.PeriodDeserializer");
        this.add("org.joda.time.Interval", "com.fasterxml.jackson.datatype.joda.ser.IntervalSerializer", "com.fasterxml.jackson.datatype.joda.deser.IntervalDeserializer");
        this.add("org.joda.time.MonthDay", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer", "com.fasterxml.jackson.datatype.joda.deser.MonthDayDeserializer");
        this.add("org.joda.time.YearMonth", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer", "com.fasterxml.jackson.datatype.joda.deser.YearMonthDeserializer");
    }

    private <T> void add(Class<? extends T> serializerType, JsonSerializer<T> serializer, Class<T> deserializerType, JsonDeserializer<? extends T> deserializer) {
        this.addSerializer(serializerType, serializer);
        this.addDeserializer(deserializerType, deserializer);
    }

    private void add(String typeName, String serializerClassName, String deserializerClassName) {
        try {
            Class<?> type = Class.forName(typeName);
            Class<?> jsonSerializerClass = Class.forName(serializerClassName);
            JsonSerializer serializer = (JsonSerializer)jsonSerializerClass.newInstance();
            this.addSerializer(type, serializer);
            Class<?> jsonDeserializerClass = Class.forName(deserializerClassName);
            if (deserializerClassName.equals("com.fasterxml.jackson.datatype.joda.deser.DateTimeDeserializer")) {
                Class<?> dateTimeType = Class.forName("org.joda.time.DateTime");
                Constructor<?> constructor = jsonDeserializerClass.getConstructor(Class.class);
                JsonDeserializer deserializer = (JsonDeserializer)constructor.newInstance(dateTimeType);
                this.addDeserializer(type, deserializer);
            } else {
                JsonDeserializer deserializer = (JsonDeserializer)jsonDeserializerClass.newInstance();
                this.addDeserializer(type, deserializer);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

