/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.internal;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchException;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.meta.CouchEntityMeta;
import org.tiogasolutions.couchace.core.api.meta.CouchMetaRepository;
import org.tiogasolutions.couchace.core.api.query.CouchPageNavigation;
import org.tiogasolutions.couchace.core.api.query.CouchPageQuery;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.couchace.core.api.request.GetDocumentRequest;
import org.tiogasolutions.couchace.core.api.request.GetEntityRequest;
import org.tiogasolutions.couchace.core.api.response.CouchDocument;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.api.response.EntityDocument;
import org.tiogasolutions.couchace.core.api.response.GetDocumentResponse;
import org.tiogasolutions.couchace.core.api.response.GetEntityResponse;
import org.tiogasolutions.couchace.core.api.response.TextDocument;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpClient;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpResponse;
import org.tiogasolutions.couchace.core.spi.json.CouchJsonStrategy;

public class GetResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(GetResponseBuilder.class);
    private final CouchDatabase couch;
    private final CouchHttpClient httpClient;
    private final CouchJsonStrategy jsonStrategy;
    private final CouchMetaRepository metaRepository;

    public GetResponseBuilder(CouchDatabase couch) {
        this.couch = couch;
        this.httpClient = couch.getHttpClient();
        this.jsonStrategy = couch.getJsonStrategy();
        this.metaRepository = couch.getMetaRepository();
    }

    public <T> GetEntityResponse<T> buildEntityResponse(GetEntityRequest<T> request, CouchHttpResponse httpResponse) {
        GetEntityResponse<T> entityResponse;
        CouchMediaType contentType = CouchMediaType.APPLICATION_JSON;
        CouchEntityMeta<T> entityMeta = this.metaRepository.getOrCreateEntityMeta(request.getEntityClass());
        if (httpResponse.isSuccess()) {
            if (request.getDocumentId() != null) {
                EntityDocument<T> entityDocument = this.jsonStrategy.readEntityDocument(this.couch.get(), entityMeta, httpResponse.getStringContent());
                entityResponse = GetEntityResponse.withEntity(httpResponse.getUri(), httpResponse.getHttpStatus(), contentType, entityMeta.getEntityClass(), entityDocument);
            } else {
                CouchPageNavigation couchPageNavigation;
                List<EntityDocument<T>> entityDocuments = this.jsonStrategy.readEntityDocuments(this.couch.get(), entityMeta, httpResponse.getStringContent());
                if (request.getViewQuery() != null) {
                    couchPageNavigation = this.buildPageNavigationForViewQuery(httpResponse.getUri(), entityDocuments, request.getViewQuery());
                } else if (request.getPageQuery() != null) {
                    couchPageNavigation = this.buildPageNavigationForPageQuery(httpResponse.getUri(), entityDocuments, request.getPageQuery());
                } else {
                    throw new CouchException(CouchHttpStatus.BAD_REQUEST, "Get request did not supply document id, view query or page query.");
                }
                entityResponse = GetEntityResponse.withEntities(httpResponse.getUri(), httpResponse.getHttpStatus(), contentType, entityMeta.getEntityClass(), couchPageNavigation, entityDocuments);
            }
        } else {
            CouchErrorContent errorContent = CouchErrorContent.parseJson(httpResponse.getStringContent());
            entityResponse = GetEntityResponse.withError(httpResponse.getUri(), httpResponse.getHttpStatus(), contentType, entityMeta.getEntityClass(), errorContent);
        }
        return entityResponse;
    }

    public GetDocumentResponse buildDocumentResponse(GetDocumentRequest request, CouchHttpResponse httpResponse) {
        GetDocumentResponse docResponse;
        if (httpResponse.isSuccess()) {
            if (request.getDocumentId() != null && (request.getDocumentId().equals("_all_docs") || request.getDocumentId().startsWith("/_all_docs?"))) {
                List<TextDocument> documentList = this.jsonStrategy.readTextDocuments(httpResponse.getStringContent());
                docResponse = GetDocumentResponse.withDocuments(httpResponse.getUri(), httpResponse.getHttpStatus(), httpResponse.getContentType(), CouchPageNavigation.empty(), documentList);
            } else if (request.getDocumentId() != null) {
                TextDocument textDocument = this.jsonStrategy.readTextDocument(httpResponse.getStringContent());
                docResponse = GetDocumentResponse.withDocument(httpResponse.getUri(), httpResponse.getHttpStatus(), httpResponse.getContentType(), textDocument);
            } else if (request.getDocumentId() != null && (request.getDocumentId().equals("_all_docs") || request.getDocumentId().startsWith("/_all_docs?"))) {
                List<TextDocument> documentList = this.jsonStrategy.readTextDocuments(httpResponse.getStringContent());
                docResponse = GetDocumentResponse.withDocuments(httpResponse.getUri(), httpResponse.getHttpStatus(), httpResponse.getContentType(), CouchPageNavigation.empty(), documentList);
            } else {
                CouchPageNavigation couchPageNavigation;
                List<TextDocument> documentList = this.jsonStrategy.readTextDocuments(httpResponse.getStringContent());
                if (request.getViewQuery() != null) {
                    couchPageNavigation = this.buildPageNavigationForViewQuery(httpResponse.getUri(), documentList, request.getViewQuery());
                } else if (request.getPageQuery() != null) {
                    couchPageNavigation = this.buildPageNavigationForPageQuery(httpResponse.getUri(), documentList, request.getPageQuery());
                } else {
                    throw new CouchException(CouchHttpStatus.BAD_REQUEST, "Get request did not supply document id, view query or page query.");
                }
                docResponse = GetDocumentResponse.withDocuments(httpResponse.getUri(), httpResponse.getHttpStatus(), httpResponse.getContentType(), couchPageNavigation, documentList);
            }
        } else {
            CouchErrorContent errorContent = CouchErrorContent.parseJson(httpResponse.getStringContent());
            docResponse = GetDocumentResponse.withError(httpResponse.getUri(), httpResponse.getHttpStatus(), CouchMediaType.APPLICATION_JSON, errorContent);
        }
        return docResponse;
    }

    protected CouchPageNavigation buildPageNavigationForPageQuery(URI requestedPageUri, List<? extends CouchDocument> documentList, CouchPageQuery pageQuery) {
        CouchPageNavigation pageNavigation;
        String backPageUri = null;
        if (!documentList.isEmpty()) {
            CouchDocument pageBeginEntity = documentList.get(0);
            backPageUri = this.httpClient.pageUri(requestedPageUri, pageBeginEntity, pageQuery.isForward()).toString();
        }
        String forwardPageUri = null;
        if (documentList.size() > pageQuery.getPageSize()) {
            documentList.remove(pageQuery.getPageSize());
            CouchDocument pageEndEntity = documentList.get(documentList.size() - 1);
            forwardPageUri = this.httpClient.pageUri(requestedPageUri, pageEndEntity, pageQuery.isReverse()).toString();
        }
        if (pageQuery.isReverse()) {
            Collections.reverse(documentList);
            pageNavigation = new CouchPageNavigation(pageQuery.getPageSize(), pageQuery.getRequestedPage(), forwardPageUri, backPageUri, pageQuery.isIncludeDocs());
        } else {
            pageNavigation = new CouchPageNavigation(pageQuery.getPageSize(), pageQuery.getRequestedPage(), backPageUri, forwardPageUri, pageQuery.isIncludeDocs());
        }
        return pageNavigation;
    }

    protected CouchPageNavigation buildPageNavigationForViewQuery(URI requestedPageUri, List<? extends CouchDocument> documentList, CouchViewQuery viewQuery) {
        String requestedPage;
        int designIndex;
        String nextPage = null;
        if (viewQuery.getLimit() > 0 && documentList.size() > viewQuery.getLimit()) {
            documentList.remove(viewQuery.getLimit());
            CouchDocument pageEndEntityDoc = documentList.get(documentList.size() - 1);
            nextPage = this.httpClient.pageUri(requestedPageUri, pageEndEntityDoc, false).toString();
        }
        if ((designIndex = (requestedPage = requestedPageUri.toString()).indexOf("_design")) > 0) {
            requestedPage = requestedPage.substring(designIndex);
        }
        return new CouchPageNavigation(viewQuery.getLimit(), requestedPage, null, nextPage, viewQuery.isIncludeDocs());
    }
}

