/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.internal.util;

public class StringUtil {
    public static String appendNullSafe(String appendTo, String appendValue) {
        if (appendValue == null) {
            return appendTo;
        }
        if (appendTo == null) {
            return appendValue;
        }
        return appendTo + appendValue;
    }

    public static String nullIfEmpty(String value) {
        return value != null && value.length() > 0 ? value : null;
    }

    public static String nullIfBlank(String value) {
        return value != null && !value.trim().isEmpty() ? value : null;
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static boolean isNotBlank(String value) {
        return value != null && !value.trim().isEmpty();
    }

    public static String arrayToString(Object[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        for (Object object : array) {
            if (object != null) {
                sb.append(object.toString());
            }
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    public static String label(String str, char ... delimiters) {
        if (delimiters == null || delimiters.length == 0) {
            delimiters = new char[]{' ', '_'};
        }
        if (StringUtil.isBlank(str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (StringUtil.isDelimiter(ch, delimiters)) {
                buffer[i] = 32;
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                buffer[i] = Character.toTitleCase(ch);
                capitalizeNext = false;
                continue;
            }
            buffer[i] = Character.toLowerCase(ch);
        }
        return new String(buffer);
    }

    public static String labelCapitalizeFirst(String str, char ... delimiters) {
        if (delimiters == null || delimiters.length == 0) {
            delimiters = new char[]{' ', '_'};
        }
        if (StringUtil.isBlank(str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (StringUtil.isDelimiter(ch, delimiters)) {
                buffer[i] = 32;
                continue;
            }
            if (capitalizeNext) {
                buffer[i] = Character.toTitleCase(ch);
                capitalizeNext = false;
                continue;
            }
            buffer[i] = Character.toLowerCase(ch);
        }
        return new String(buffer);
    }

    public static String capitalize(String str, char ... delimiters) {
        if (delimiters == null || delimiters.length == 0) {
            delimiters = new char[]{' ', '_'};
        }
        if (StringUtil.isBlank(str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (StringUtil.isDelimiter(ch, delimiters)) {
                capitalizeNext = true;
                continue;
            }
            if (!capitalizeNext) continue;
            buffer[i] = Character.toTitleCase(ch);
            capitalizeNext = false;
        }
        return new String(buffer);
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        for (char delimiter : delimiters) {
            if (ch != delimiter) continue;
            return true;
        }
        return false;
    }
}

