/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.jackson.internal;

import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.core.api.meta.CouchEmbeddedAttachmentMeta;
import org.tiogasolutions.couchace.core.api.meta.CouchEntityMeta;
import org.tiogasolutions.couchace.core.api.meta.CouchMetaRepository;
import org.tiogasolutions.couchace.core.internal.util.ClassUtil;

public class CouchJacksonSerializerIntrospector
extends JacksonAnnotationIntrospector {
    private static final Logger log = LoggerFactory.getLogger(CouchJacksonSerializerIntrospector.class);
    private final CouchMetaRepository couchMetaRepository;

    public CouchJacksonSerializerIntrospector(CouchMetaRepository couchMetaRepository) {
        this.couchMetaRepository = couchMetaRepository;
    }

    public String[] findPropertiesToIgnore(Annotated ac) {
        Class entityClass;
        CouchEntity couchEntity;
        if (log.isTraceEnabled()) {
            log.trace("Finding properties to ignore on: " + ac);
        }
        String[] propertiesToIgnore = super.findPropertiesToIgnore(ac);
        if (ac != null && ac.getRawType() != null && (couchEntity = (CouchEntity)ClassUtil.findClassAnnotation((Class)(entityClass = ac.getRawType()), CouchEntity.class)) != null) {
            HashSet<String> ignorePropertySet = new HashSet<String>();
            CouchEntityMeta entityMeta = this.couchMetaRepository.getOrCreateEntityMeta(ac.getRawType());
            if (entityMeta != null) {
                if (entityMeta.hasId() && entityMeta.getIdPattern() == null) {
                    ignorePropertySet.add(entityMeta.getIdName());
                }
                if (entityMeta.hasRevision()) {
                    ignorePropertySet.add(entityMeta.getRevisionName());
                }
                if (entityMeta.hasEmbeddedAttachments()) {
                    List attachmentMetaList = entityMeta.getEmbeddedAttachmentMetaList();
                    for (CouchEmbeddedAttachmentMeta embeddedAttachmentMeta : attachmentMetaList) {
                        ignorePropertySet.add(embeddedAttachmentMeta.getValueAccessor().getPropertyName());
                    }
                }
            }
            propertiesToIgnore = ignorePropertySet.toArray(new String[ignorePropertySet.size()]);
        }
        return propertiesToIgnore;
    }
}

