/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.attr;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableAttributeHolderNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.AttributeNameProcessorMatcher;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.IProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.processor.ProcessorResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttrProcessor
extends AbstractProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IAttributeNameProcessorMatcher matcher;

    protected AbstractAttrProcessor(String attributeName) {
        this(new AttributeNameProcessorMatcher(attributeName));
    }

    protected AbstractAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        this.matcher = matcher;
    }

    public final IProcessorMatcher<? extends NestableAttributeHolderNode> getMatcher() {
        return this.matcher;
    }

    @Override
    protected final ProcessorResult doProcess(Arguments arguments, ProcessorMatchingContext processorMatchingContext, Node node) {
        Element element = (Element)node;
        String[] attributeNames = this.matcher.getAttributeNames(processorMatchingContext);
        String matchedAttributeName = null;
        for (String attributeName : attributeNames) {
            if (!element.hasNormalizedAttribute(attributeName)) continue;
            matchedAttributeName = attributeName;
            break;
        }
        if (this.logger.isTraceEnabled()) {
            String attributeValue = ((Element)node).getAttributeValueFromNormalizedName(matchedAttributeName);
            this.logger.trace("[THYMELEAF][{}][{}] Processing attribute \"{}\" with value \"{}\" in element \"{}\"", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName(), matchedAttributeName, attributeValue == null ? "" : attributeValue, ((Element)node).getNormalizedName()});
        }
        return this.processAttribute(arguments, element, matchedAttributeName);
    }

    protected abstract ProcessorResult processAttribute(Arguments var1, Element var2, String var3);
}

