/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.jackson.internal;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import java.util.HashMap;
import java.util.Map;
import org.tiogasolutions.couchace.core.api.injectable.CouchInjectables;
import org.tiogasolutions.couchace.core.api.injectable.MissingInjectableResponse;

public class CustomJacksonInjectableValues
extends InjectableValues {
    private final MissingInjectableResponse missingInjectableResponse;
    private final Map<String, Object> values = new HashMap<String, Object>();
    private CouchInjectables injectables;

    public CustomJacksonInjectableValues(MissingInjectableResponse missingInjectableResponse) {
        this.missingInjectableResponse = missingInjectableResponse;
    }

    public CustomJacksonInjectableValues(MissingInjectableResponse missingInjectableResponse, CouchInjectables injectables) {
        this.missingInjectableResponse = missingInjectableResponse;
        this.injectables = injectables;
    }

    public Object findInjectableValue(Object valueId, DeserializationContext context, BeanProperty forProperty, Object beanInstance) {
        if (!(valueId instanceof String)) {
            String type = valueId == null ? "[null]" : valueId.getClass().getName();
            throw new IllegalArgumentException("Unrecognized inject value id type (" + type + "), expecting String");
        }
        String key = (String)valueId;
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        if (this.injectables != null && this.injectables.hasValue(key)) {
            return this.injectables.getValue(key);
        }
        if (this.missingInjectableResponse == MissingInjectableResponse.THROW_EXCEPTION) {
            throw new IllegalArgumentException("No injectable value found for key '" + key + forProperty.getName() + "'");
        }
        return null;
    }

    public CustomJacksonInjectableValues addValue(String key, Object value) {
        this.values.put(key, value);
        return this;
    }
}

