/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.route;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.notify.pub.route.ArgValueMap;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.notify.pub.route.DestinationStatus;

public class DestinationDef {
    private final String name;
    private final String provider;
    private DestinationStatus destinationStatus;
    private final Map<String, Object> argMap = new HashMap<String, Object>();

    public DestinationDef(String name, String provider, Map<String, Object> argMap) {
        this.name = ExceptionUtils.assertNotZeroLength((String)name, (String)"name");
        this.provider = ExceptionUtils.assertNotZeroLength((String)provider, (String)"provider");
        this.destinationStatus = DestinationStatus.ENABLED;
        if (argMap != null) {
            for (Map.Entry<String, Object> entry : argMap.entrySet()) {
                this.addArg(entry.getKey(), entry.getValue());
            }
        }
    }

    public Destination toDestination() {
        return new Destination(this.name, this.provider, this.destinationStatus, this.argMap);
    }

    @JsonCreator
    public DestinationDef(@JsonProperty(value="name") String name, @JsonProperty(value="provider") String provider) {
        this.name = ExceptionUtils.assertNotZeroLength((String)name, (String)"name");
        this.provider = ExceptionUtils.assertNotZeroLength((String)provider, (String)"provider");
        this.destinationStatus = DestinationStatus.ENABLED;
    }

    public String getName() {
        return this.name;
    }

    public String getProvider() {
        return this.provider;
    }

    public DestinationStatus getDestinationStatus() {
        return this.destinationStatus;
    }

    public DestinationDef setDestinationStatus(DestinationStatus destinationStatus) {
        this.destinationStatus = destinationStatus;
        return this;
    }

    @JsonIgnore
    public ArgValueMap getArgValueMap() {
        return new ArgValueMap(this.argMap);
    }

    @JsonAnyGetter
    public Map<String, Object> getArgMap() {
        return this.argMap;
    }

    @JsonAnySetter
    public DestinationDef addArg(String name, Object value) {
        this.argMap.put(name, value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestinationDef that = (DestinationDef)o;
        if (this.argMap != null ? !this.argMap.equals(that.argMap) : that.argMap != null) {
            return false;
        }
        if (this.destinationStatus != that.destinationStatus) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.provider != null ? !this.provider.equals(that.provider) : that.provider != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        result = 31 * result + (this.destinationStatus != null ? this.destinationStatus.hashCode() : 0);
        result = 31 * result + (this.argMap != null ? this.argMap.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DestinationDef{name='" + this.name + '\'' + ", provider='" + this.provider + '\'' + ", destinationStatus=" + (Object)((Object)this.destinationStatus) + ", argMap=" + this.argMap + '}';
    }
}

