/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.server.grizzly;

import ch.qos.logback.classic.Level;
import java.nio.file.Path;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.app.common.AppPathResolver;
import org.tiogasolutions.app.common.AppUtils;
import org.tiogasolutions.notify.engine.web.NotifyApplication;
import org.tiogasolutions.runners.grizzly.GrizzlyServer;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.runners.grizzly.spring.ApplicationResolver;
import org.tiogasolutions.runners.grizzly.spring.GrizzlySpringServer;
import org.tiogasolutions.runners.grizzly.spring.ServerConfigResolver;

public class NotifyServer {
    private static final Logger log = LoggerFactory.getLogger(NotifyServer.class);

    public static void main(String ... args) throws Exception {
        AppUtils.initLogback((Level)Level.WARN);
        AppUtils.setLogLevel((Level)Level.INFO, (Class[])new Class[]{NotifyServer.class});
        AppUtils.setLogLevel((Level)Level.INFO, (Class[])GrizzlySpringServer.GRIZZLY_CLASSES);
        AppPathResolver resolver = new AppPathResolver("notify.");
        Path runtimeDir = resolver.resolveRuntimePath();
        Path configDir = resolver.resolveConfigDir(runtimeDir);
        Path logbackFile = AppUtils.initLogback((Path)configDir, (String)"notify.log.config", (String)"logback.xml");
        String springConfigPath = resolver.resolveSpringPath(configDir, null);
        String activeProfiles = resolver.resolveSpringProfiles();
        log.info("Starting server:\n  *  Runtime Dir:  {}\n  *  Config Dir:   {}\n  *  Logback File: {}\n  *  Spring Path ({}):  {}", new Object[]{runtimeDir, configDir, logbackFile, activeProfiles, springConfigPath});
        GrizzlySpringServer grizzlyServer = new GrizzlySpringServer(ServerConfigResolver.fromClass(GrizzlyServerConfig.class), ApplicationResolver.fromClass(NotifyApplication.class), activeProfiles, springConfigPath);
        grizzlyServer.packages(new String[]{"org.tiogasolutions.notify"});
        if (Arrays.asList(args).contains("-shutdown")) {
            GrizzlyServer.shutdownRemote((GrizzlyServerConfig)grizzlyServer.getConfig());
            log.warn("Shutting down server at {}:{}", (Object)grizzlyServer.getConfig().getHostName(), (Object)grizzlyServer.getConfig().getShutdownPort());
            System.exit(0);
            return;
        }
        grizzlyServer.start();
    }
}

