/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.pub.common;

import java.io.Serializable;

public enum RequestStatus implements Serializable
{
    pending("Pending"),
    processed("Processed"),
    failed("Failed"),
    warning("Warning"),
    denied("Denied");

    private final String label;

    private RequestStatus(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name();
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isPending() {
        return this == pending;
    }

    public boolean isProcessed() {
        return this == processed;
    }

    public boolean isFailed() {
        return this == failed;
    }

    public boolean isWarning() {
        return this == warning;
    }

    public boolean isDenied() {
        return this == denied;
    }

    public String getColor() {
        if (this.isFailed()) {
            return "red";
        }
        if (this.isWarning()) {
            return "yellow";
        }
        if (this.isDenied()) {
            return "orange";
        }
        return "";
    }
}

