/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.smtp;

import java.io.File;
import java.util.Collections;
import org.springframework.stereotype.Component;
import org.tiogasolutions.dev.domain.comm.AuthenticationMethod;
import org.tiogasolutions.notify.kernel.message.HtmlMessage;
import org.tiogasolutions.notify.kernel.message.ThymeleafMessageBuilder;
import org.tiogasolutions.notify.kernel.task.TaskProcessor;
import org.tiogasolutions.notify.kernel.task.TaskProcessorType;
import org.tiogasolutions.notify.processor.smtp.EmailMessage;
import org.tiogasolutions.notify.processor.smtp.SmtpAuthType;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.route.ArgValueMap;
import org.tiogasolutions.notify.pub.task.Task;
import org.tiogasolutions.notify.pub.task.TaskResponse;

@Component
public class SmtpTaskProcessor
implements TaskProcessor {
    private static final TaskProcessorType PROCESSOR_TYPE = new TaskProcessorType("smtp");
    private final ThymeleafMessageBuilder messageBuilder = new ThymeleafMessageBuilder();

    public boolean isReady() {
        return true;
    }

    public TaskResponse processTask(DomainProfile domainProfile, Notification notification, Task task) {
        ArgValueMap argMap = task.getDestination().getArgValueMap();
        String templatePath = this.messageBuilder.getEmailTemplatePath(argMap, "templatePath");
        HtmlMessage htmlMessage = this.messageBuilder.createHtmlMessage(domainProfile, notification, task, templatePath);
        EmailMessage emailMessage = this.createEmailMessage(argMap);
        emailMessage.send(htmlMessage.getSubject(), null, htmlMessage.getBody(), new File[0]);
        return TaskResponse.complete((String)"Email sent");
    }

    protected EmailMessage createEmailMessage(ArgValueMap argMap) {
        SmtpAuthType authType = (SmtpAuthType)((Object)argMap.asEnum(SmtpAuthType.class, "smtpAuthType"));
        String host = argMap.asString("smtpHost");
        String port = argMap.asString("smtpPort");
        String username = argMap.asString("smtpUsername");
        String password = argMap.asString("smtpPassword");
        String from = argMap.asString("smtpFrom");
        String recipient = argMap.asString("smtpRecipients");
        EmailMessage message = new EmailMessage(host, port, Collections.singletonList(recipient));
        message.setFrom(from);
        if (authType.isTls()) {
            message.setAuthentication(AuthenticationMethod.TLS, username, password);
        } else if (authType.isSsl()) {
            message.setAuthentication(AuthenticationMethod.SSL, username, password);
        } else {
            message.setAuthentication(AuthenticationMethod.NONE, username, password);
        }
        return message;
    }

    public TaskProcessorType getType() {
        return PROCESSOR_TYPE;
    }
}

