/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AnnotationUtils {
    public static final String VALUE = "value";
    private static final Map<AnnotationCacheKey, Annotation> findAnnotationCache = new ConcurrentReferenceHashMap<AnnotationCacheKey, Annotation>(256);
    private static final Map<Class<?>, Boolean> annotatedInterfaceCache = new ConcurrentReferenceHashMap(256);
    private static transient Log logger;

    public static <T extends Annotation> T getAnnotation(Annotation ann, Class<T> annotationType) {
        if (annotationType.isInstance(ann)) {
            return (T)ann;
        }
        try {
            return ann.annotationType().getAnnotation(annotationType);
        }
        catch (Exception ex) {
            AnnotationUtils.logIntrospectionFailure(ann.annotationType(), ex);
            return null;
        }
    }

    public static <T extends Annotation> T getAnnotation(AnnotatedElement annotatedElement, Class<T> annotationType) {
        try {
            T ann = annotatedElement.getAnnotation(annotationType);
            if (ann == null) {
                Annotation metaAnn;
                Annotation[] annotationArray = annotatedElement.getAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n && (ann = (metaAnn = annotationArray[i]).annotationType().getAnnotation(annotationType)) == null; ++i) {
                }
            }
            return ann;
        }
        catch (Exception ex) {
            AnnotationUtils.logIntrospectionFailure(annotatedElement, ex);
            return null;
        }
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotatedElement) {
        try {
            return annotatedElement.getAnnotations();
        }
        catch (Exception ex) {
            AnnotationUtils.logIntrospectionFailure(annotatedElement, ex);
            return null;
        }
    }

    public static Annotation[] getAnnotations(Method method) {
        try {
            return BridgeMethodResolver.findBridgedMethod(method).getAnnotations();
        }
        catch (Exception ex) {
            AnnotationUtils.logIntrospectionFailure(method, ex);
            return null;
        }
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
        return AnnotationUtils.getAnnotation((AnnotatedElement)resolvedMethod, annotationType);
    }

    public static <A extends Annotation> Set<A> getRepeatableAnnotation(Method method, Class<? extends Annotation> containerAnnotationType, Class<A> annotationType) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
        return AnnotationUtils.getRepeatableAnnotation((AnnotatedElement)resolvedMethod, containerAnnotationType, annotationType);
    }

    public static <A extends Annotation> Set<A> getRepeatableAnnotation(AnnotatedElement annotatedElement, Class<? extends Annotation> containerAnnotationType, Class<A> annotationType) {
        try {
            if (annotatedElement.getAnnotations().length > 0) {
                return new AnnotationCollector<A>(containerAnnotationType, annotationType).getResult(annotatedElement);
            }
        }
        catch (Exception ex) {
            AnnotationUtils.logIntrospectionFailure(annotatedElement, ex);
        }
        return Collections.emptySet();
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        AnnotationCacheKey cacheKey = new AnnotationCacheKey(method, annotationType);
        Annotation result = findAnnotationCache.get(cacheKey);
        if (result == null) {
            result = AnnotationUtils.getAnnotation(method, annotationType);
            Class<?> clazz = method.getDeclaringClass();
            if (result == null) {
                result = AnnotationUtils.searchOnInterfaces(method, annotationType, clazz.getInterfaces());
            }
            while (result == null && (clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class)) {
                try {
                    Method equivalentMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    result = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (result != null) continue;
                result = AnnotationUtils.searchOnInterfaces(method, annotationType, clazz.getInterfaces());
            }
            if (result != null) {
                findAnnotationCache.put(cacheKey, result);
            }
        }
        return (A)result;
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class<?> ... ifcs) {
        A annotation = null;
        for (Class<?> iface : ifcs) {
            if (!AnnotationUtils.isInterfaceWithAnnotatedMethods(iface)) continue;
            try {
                Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (annotation != null) break;
        }
        return annotation;
    }

    private static boolean isInterfaceWithAnnotatedMethods(Class<?> iface) {
        Boolean flag = annotatedInterfaceCache.get(iface);
        if (flag != null) {
            return flag;
        }
        boolean found = false;
        for (Method ifcMethod : iface.getMethods()) {
            try {
                if (ifcMethod.getAnnotations().length <= 0) continue;
                found = true;
                break;
            }
            catch (Exception ex) {
                AnnotationUtils.logIntrospectionFailure(ifcMethod, ex);
            }
        }
        annotatedInterfaceCache.put(iface, found);
        return found;
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        AnnotationCacheKey cacheKey = new AnnotationCacheKey(clazz, annotationType);
        Annotation result = findAnnotationCache.get(cacheKey);
        if (result == null && (result = AnnotationUtils.findAnnotation(clazz, annotationType, new HashSet<Annotation>())) != null) {
            findAnnotationCache.put(cacheKey, result);
        }
        return (A)result;
    }

    private static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType, Set<Annotation> visited) {
        Assert.notNull(clazz, "Class must not be null");
        try {
            Annotation[] anns;
            for (Annotation ann : anns = clazz.getDeclaredAnnotations()) {
                if (!ann.annotationType().equals(annotationType)) continue;
                return (A)ann;
            }
            Annotation[] annotationArray = anns;
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                A annotation;
                Annotation ann;
                ann = annotationArray[i];
                if (AnnotationUtils.isInJavaLangAnnotationPackage(ann) || !visited.add(ann) || (annotation = AnnotationUtils.findAnnotation(ann.annotationType(), annotationType, visited)) == null) continue;
                return annotation;
            }
        }
        catch (Exception ex) {
            AnnotationUtils.logIntrospectionFailure(clazz, ex);
            return null;
        }
        for (Class<?> ifc : clazz.getInterfaces()) {
            A annotation = AnnotationUtils.findAnnotation(ifc, annotationType, visited);
            if (annotation == null) continue;
            return annotation;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || superclass.equals(Object.class)) {
            return null;
        }
        return AnnotationUtils.findAnnotation(superclass, annotationType, visited);
    }

    public static Class<?> findAnnotationDeclaringClass(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        if (AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) {
            return clazz;
        }
        return AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz.getSuperclass());
    }

    public static Class<?> findAnnotationDeclaringClassForTypes(List<Class<? extends Annotation>> annotationTypes, Class<?> clazz) {
        Assert.notEmpty(annotationTypes, "The list of annotation types must not be empty");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) continue;
            return clazz;
        }
        return AnnotationUtils.findAnnotationDeclaringClassForTypes(annotationTypes, clazz.getSuperclass());
    }

    public static boolean isAnnotationDeclaredLocally(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        boolean declaredLocally = false;
        try {
            for (Annotation ann : clazz.getDeclaredAnnotations()) {
                if (!ann.annotationType().equals(annotationType)) continue;
                declaredLocally = true;
                break;
            }
        }
        catch (Exception ex) {
            AnnotationUtils.logIntrospectionFailure(clazz, ex);
        }
        return declaredLocally;
    }

    public static boolean isAnnotationInherited(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isAnnotationPresent(annotationType) && !AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz);
    }

    public static boolean isInJavaLangAnnotationPackage(Annotation annotation) {
        Assert.notNull(annotation, "Annotation must not be null");
        return annotation.annotationType().getName().startsWith("java.lang.annotation");
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation) {
        return AnnotationUtils.getAnnotationAttributes(annotation, false, false);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation, boolean classValuesAsString) {
        return AnnotationUtils.getAnnotationAttributes(annotation, classValuesAsString, false);
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        Method[] methods;
        AnnotationAttributes attrs = new AnnotationAttributes();
        for (Method method : methods = annotation.annotationType().getDeclaredMethods()) {
            if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                attrs.put(method.getName(), AnnotationUtils.adaptValue(value, classValuesAsString, nestedAnnotationsAsMap));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not obtain annotation attribute values", ex);
            }
        }
        return attrs;
    }

    static Object adaptValue(Object value, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        int i;
        if (classValuesAsString) {
            if (value instanceof Class) {
                value = ((Class)value).getName();
            } else if (value instanceof Class[]) {
                Class[] clazzArray = (Class[])value;
                String[] newValue = new String[clazzArray.length];
                for (i = 0; i < clazzArray.length; ++i) {
                    newValue[i] = clazzArray[i].getName();
                }
                value = newValue;
            }
        }
        if (nestedAnnotationsAsMap && value instanceof Annotation) {
            return AnnotationUtils.getAnnotationAttributes((Annotation)value, classValuesAsString, true);
        }
        if (nestedAnnotationsAsMap && value instanceof Annotation[]) {
            Annotation[] realAnnotations = (Annotation[])value;
            AnnotationAttributes[] mappedAnnotations = new AnnotationAttributes[realAnnotations.length];
            for (i = 0; i < realAnnotations.length; ++i) {
                mappedAnnotations[i] = AnnotationUtils.getAnnotationAttributes(realAnnotations[i], classValuesAsString, true);
            }
            return mappedAnnotations;
        }
        return value;
    }

    public static Object getValue(Annotation annotation) {
        return AnnotationUtils.getValue(annotation, VALUE);
    }

    public static Object getValue(Annotation annotation, String attributeName) {
        if (annotation == null || !StringUtils.hasLength(attributeName)) {
            return null;
        }
        try {
            Method method = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            ReflectionUtils.makeAccessible(method);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getDefaultValue(Annotation annotation) {
        return AnnotationUtils.getDefaultValue(annotation, VALUE);
    }

    public static Object getDefaultValue(Annotation annotation, String attributeName) {
        if (annotation == null) {
            return null;
        }
        return AnnotationUtils.getDefaultValue(annotation.annotationType(), attributeName);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getDefaultValue(annotationType, VALUE);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType, String attributeName) {
        if (annotationType == null || !StringUtils.hasLength(attributeName)) {
            return null;
        }
        try {
            return annotationType.getDeclaredMethod(attributeName, new Class[0]).getDefaultValue();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void logIntrospectionFailure(AnnotatedElement annotatedElement, Exception ex) {
        Log loggerToUse = logger;
        if (loggerToUse == null) {
            logger = loggerToUse = LogFactory.getLog(AnnotationUtils.class);
        }
        if (loggerToUse.isInfoEnabled()) {
            loggerToUse.info((Object)("Failed to introspect annotations on [" + annotatedElement + "]: " + ex));
        }
    }

    private static class AnnotationCollector<A extends Annotation> {
        private final Class<? extends Annotation> containerAnnotationType;
        private final Class<A> annotationType;
        private final Set<AnnotatedElement> visited = new HashSet<AnnotatedElement>();
        private final Set<A> result = new LinkedHashSet<A>();

        public AnnotationCollector(Class<? extends Annotation> containerAnnotationType, Class<A> annotationType) {
            this.containerAnnotationType = containerAnnotationType;
            this.annotationType = annotationType;
        }

        public Set<A> getResult(AnnotatedElement element) {
            this.process(element);
            return Collections.unmodifiableSet(this.result);
        }

        private void process(AnnotatedElement annotatedElement) {
            if (this.visited.add(annotatedElement)) {
                for (Annotation ann : annotatedElement.getAnnotations()) {
                    if (ObjectUtils.nullSafeEquals(this.annotationType, ann.annotationType())) {
                        this.result.add(ann);
                        continue;
                    }
                    if (ObjectUtils.nullSafeEquals(this.containerAnnotationType, ann.annotationType())) {
                        this.result.addAll(this.getValue(ann));
                        continue;
                    }
                    if (AnnotationUtils.isInJavaLangAnnotationPackage(ann)) continue;
                    this.process(ann.annotationType());
                }
            }
        }

        private List<A> getValue(Annotation annotation) {
            try {
                Method method = annotation.annotationType().getDeclaredMethod(AnnotationUtils.VALUE, new Class[0]);
                ReflectionUtils.makeAccessible(method);
                return Arrays.asList((Annotation[])method.invoke((Object)annotation, new Object[0]));
            }
            catch (Exception ex) {
                return Collections.emptyList();
            }
        }
    }

    private static class AnnotationCacheKey {
        private final AnnotatedElement element;
        private final Class<? extends Annotation> annotationType;

        public AnnotationCacheKey(AnnotatedElement element, Class<? extends Annotation> annotationType) {
            this.element = element;
            this.annotationType = annotationType;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationCacheKey)) {
                return false;
            }
            AnnotationCacheKey otherKey = (AnnotationCacheKey)other;
            return this.element.equals(otherKey.element) && ObjectUtils.nullSafeEquals(this.annotationType, otherKey.annotationType);
        }

        public int hashCode() {
            return this.element.hashCode() * 29 + this.annotationType.hashCode();
        }
    }
}

