/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.notify.pub.common.ExceptionInfo;
import org.tiogasolutions.notify.pub.task.TaskResponseAction;

public class TaskResponse {
    private final TaskResponseAction responseAction;
    private final String message;
    private final ExceptionInfo exceptionInfo;

    public static TaskResponse retry(String message) {
        return new TaskResponse(TaskResponseAction.RETRY, message, null);
    }

    public static TaskResponse complete(String message) {
        return new TaskResponse(TaskResponseAction.COMPLETE, message, null);
    }

    public static TaskResponse fail(String message, Throwable ex) {
        return new TaskResponse(TaskResponseAction.FAIL, message, new ExceptionInfo(ex));
    }

    public static TaskResponse fail(String message) {
        return new TaskResponse(TaskResponseAction.FAIL, message, null);
    }

    @JsonCreator
    private TaskResponse(@JsonProperty(value="responseAction") TaskResponseAction responseAction, @JsonProperty(value="message") String message, @JsonProperty(value="exceptionInfo") ExceptionInfo exceptionInfo) {
        this.responseAction = (TaskResponseAction)((Object)ExceptionUtils.assertNotNull((Object)((Object)responseAction), (String)"responseAction"));
        this.message = message;
        this.exceptionInfo = exceptionInfo;
    }

    public TaskResponseAction getResponseAction() {
        return this.responseAction;
    }

    public String getMessage() {
        return this.message;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskResponse that = (TaskResponse)o;
        if (this.exceptionInfo != null ? !this.exceptionInfo.equals(that.exceptionInfo) : that.exceptionInfo != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return this.responseAction == that.responseAction;
    }

    public int hashCode() {
        int result = this.responseAction != null ? this.responseAction.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.exceptionInfo != null ? this.exceptionInfo.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TaskResponse{responseAction=" + (Object)((Object)this.responseAction) + ", message='" + this.message + '\'' + ", exceptionInfo=" + this.exceptionInfo + '}';
    }
}

