/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.jersey;

import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.uri.UriComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.couchace.core.api.CouchException;
import org.tiogasolutions.couchace.core.api.CouchSetup;
import org.tiogasolutions.couchace.core.api.http.CouchHttpException;
import org.tiogasolutions.couchace.core.api.http.CouchHttpQueryParam;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.http.CouchMethodType;
import org.tiogasolutions.couchace.core.api.response.CouchDocument;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;
import org.tiogasolutions.couchace.core.internal.util.UriUtil;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpClient;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpResponse;
import org.tiogasolutions.couchace.core.spi.http.HttpDeleteRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpGetRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpHeadRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpPostRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpPutRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpReadRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpRequest;

public class JerseyCouchHttpClient
implements CouchHttpClient {
    private static final Logger log = LoggerFactory.getLogger(JerseyCouchHttpClient.class);
    private Client client;
    private String baseUrl;

    public void init(CouchSetup couchSetup) {
        try {
            ClientBuilder clientBuilder = ClientBuilder.newBuilder();
            if (couchSetup.getSslSetup() != null) {
                clientBuilder.sslContext(couchSetup.getSslSetup().getSSLContext());
            }
            this.client = clientBuilder.build();
            if (couchSetup.getUserName() != null) {
                HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)couchSetup.getUserName(), (String)couchSetup.getPassword());
                this.client.register((Object)feature);
            }
            this.baseUrl = couchSetup.getUrl();
        }
        catch (Throwable ex) {
            throw CouchHttpException.internalServerError((Throwable)ex);
        }
    }

    public CouchHttpResponse createDatabase(String databaseName) {
        try {
            Entity entity = Entity.entity((Object)"", (MediaType)MediaType.WILDCARD_TYPE);
            WebTarget webTarget = this.newWebTarget(databaseName);
            Response response = webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(entity);
            CouchHttpStatus statusCode = CouchHttpStatus.findByCode((int)response.getStatus());
            String eTag = this.getETag(response);
            byte[] content = (byte[])response.readEntity(byte[].class);
            CouchMediaType mediaType = CouchMediaType.fromString((String)response.getMediaType().toString());
            int contentLength = response.getLength();
            return CouchHttpResponse.builder((CouchMethodType)CouchMethodType.PUT, (URI)webTarget.getUri(), (CouchHttpStatus)statusCode).setEtag(eTag).setContent(mediaType, contentLength, (Object)content).build();
        }
        catch (Throwable ex) {
            throw CouchHttpException.internalServerError((Throwable)ex);
        }
    }

    public CouchHttpResponse deleteDatabase(String databaseName) {
        try {
            WebTarget webTarget = this.newWebTarget(databaseName);
            Response response = webTarget.request().delete();
            CouchHttpStatus statusCode = CouchHttpStatus.findByCode((int)response.getStatus());
            String eTag = this.getETag(response);
            byte[] content = (byte[])response.readEntity(byte[].class);
            CouchMediaType mediaType = CouchMediaType.fromString((String)response.getMediaType().toString());
            int contentLength = response.getLength();
            return CouchHttpResponse.builder((CouchMethodType)CouchMethodType.DELETE, (URI)webTarget.getUri(), (CouchHttpStatus)statusCode).setEtag(eTag).setContent(mediaType, contentLength, (Object)content).build();
        }
        catch (Throwable ex) {
            throw CouchHttpException.internalServerError((Throwable)ex);
        }
    }

    public CouchHttpResponse head(HttpHeadRequest request) {
        try {
            WebTarget webTarget = this.newWebTarget((HttpReadRequest)request);
            Response headResponse = webTarget.request().head();
            URI uri = webTarget.getUri();
            if (log.isDebugEnabled()) {
                log.debug("Head url: " + uri.toString());
            }
            return this.buildCouchResponse((HttpRequest)request, uri, headResponse, request.getDocumentId());
        }
        catch (Throwable ex) {
            throw CouchHttpException.internalServerError((Throwable)ex);
        }
    }

    public CouchHttpResponse get(HttpGetRequest request) {
        try {
            WebTarget webTarget = this.newWebTarget((HttpReadRequest)request);
            MediaType acceptType = request.getAcceptType() != null ? MediaType.valueOf((String)request.getAcceptType().getMediaString()) : null;
            Response getResponse = webTarget.request(new MediaType[]{acceptType}).get();
            URI uri = webTarget.getUri();
            if (log.isDebugEnabled()) {
                log.debug("Get url: " + uri.toString());
            }
            return this.buildCouchResponse((HttpRequest)request, uri, getResponse, request.getDocumentId());
        }
        catch (Throwable ex) {
            throw CouchHttpException.internalServerError((Throwable)ex);
        }
    }

    public CouchHttpResponse put(HttpPutRequest request) {
        try {
            MediaType contentType = MediaType.valueOf((String)request.getContentType().getMediaString());
            Object content = request.getContent() != null ? request.getContent() : "";
            Entity entity = Entity.entity((Object)content, (MediaType)contentType);
            WebTarget webTarget = this.newWebTarget(request.getPath());
            for (CouchHttpQueryParam queryParam : request.getHttpQuery()) {
                webTarget = webTarget.queryParam(queryParam.getName(), queryParam.getValue());
            }
            URI uri = webTarget.getUri();
            if (log.isDebugEnabled()) {
                log.debug("Put url: " + uri.toString());
            }
            Response putResponse = webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Content-Type", (Object)contentType).put(entity);
            return this.buildCouchResponse((HttpRequest)request, uri, putResponse, request.getDocumentId());
        }
        catch (Throwable ex) {
            throw CouchHttpException.internalServerError((Throwable)ex);
        }
    }

    public CouchHttpResponse post(HttpPostRequest request) {
        try {
            Entity entity = Entity.json((Object)request.getContent());
            WebTarget webTarget = this.newWebTarget(request.getPath());
            for (CouchHttpQueryParam queryParam : request.getHttpQuery()) {
                webTarget = webTarget.queryParam(queryParam.getName(), queryParam.getValue());
            }
            Response postResponse = webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(entity);
            URI uri = webTarget.getUri();
            if (log.isDebugEnabled()) {
                log.debug("POST url: " + uri.toString());
            }
            String documentId = UriUtil.lastPathElement((URI)postResponse.getLocation());
            return this.buildCouchResponse((HttpRequest)request, uri, postResponse, documentId);
        }
        catch (Throwable ex) {
            throw CouchHttpException.internalServerError((Throwable)ex);
        }
    }

    public CouchHttpResponse delete(HttpDeleteRequest request) {
        try {
            if (ArgUtil.isEmpty((String)request.getPath())) {
                throw CouchException.badRequest((String)"Attempting to delete with empty path, which would delete the database so we will fail. If you really want to delete the database use the explicit deleteDatabase method.");
            }
            WebTarget webTarget = this.newWebTarget(request.getPath());
            for (CouchHttpQueryParam queryParam : request.getHttpQuery()) {
                webTarget = webTarget.queryParam(queryParam.getName(), queryParam.getValue());
            }
            Response deleteResponse = webTarget.request().delete();
            URI uri = webTarget.getUri();
            if (log.isDebugEnabled()) {
                log.debug("DELETE url: " + uri.toString());
            }
            return this.buildCouchResponse((HttpRequest)request, uri, deleteResponse, request.getDocumentId());
        }
        catch (Throwable ex) {
            throw CouchHttpException.internalServerError((Throwable)ex);
        }
    }

    public URI pageUri(URI currentPageUri, CouchDocument document, boolean reverse) {
        try {
            String uriPath = currentPageUri.getPath();
            int designIndex = uriPath.indexOf("_design");
            if (designIndex > 0) {
                uriPath = uriPath.substring(designIndex);
            }
            UriBuilder uriBuilder = UriBuilder.fromPath((String)uriPath).queryParam("startkey", new Object[]{document.getKey().getJsonValue()}).queryParam("startkey_docid", new Object[]{document.getDocumentId()}).queryParam("skip", new Object[]{1}).queryParam("descending", new Object[]{reverse});
            MultivaluedMap query = UriComponent.decodeQuery((URI)currentPageUri, (boolean)true);
            if (query.containsKey((Object)"endkey")) {
                uriBuilder.queryParam("endkey", new Object[]{query.getFirst((Object)"endkey")});
            }
            if (query.containsKey((Object)"key")) {
                uriBuilder.queryParam("key", new Object[]{query.getFirst((Object)"key")});
            }
            return uriBuilder.build(new Object[0]);
        }
        catch (Throwable ex) {
            throw CouchHttpException.internalServerError((Throwable)ex);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public URI uri(String ... paths) {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.baseUrl);
        if (paths != null) {
            for (String path : paths) {
                uriBuilder.path(path);
            }
        }
        return uriBuilder.build(new Object[0]);
    }

    protected WebTarget newWebTarget(String url) {
        url = url == null ? "" : url;
        String middle = url.endsWith("/") ? "" : "/";
        String absoluteUrl = this.baseUrl + middle + url;
        return this.client.target(absoluteUrl);
    }

    protected WebTarget newWebTarget(HttpReadRequest request) {
        WebTarget webTarget = this.newWebTarget(request.getPath());
        for (CouchHttpQueryParam queryParam : request.getHttpQuery()) {
            webTarget = webTarget.queryParam(queryParam.getName(), queryParam.getValue());
        }
        return webTarget;
    }

    protected String getETag(Response response) {
        String eTag = response.getHeaderString("Etag");
        if (eTag != null && eTag.charAt(0) == '\"') {
            eTag = eTag.substring(1, eTag.length() - 1);
        }
        return eTag;
    }

    protected CouchHttpResponse buildCouchResponse(HttpRequest request, URI uri, Response response, String documentId) {
        CouchHttpStatus statusCode = CouchHttpStatus.findByCode((int)response.getStatus());
        String eTag = this.getETag(response);
        CouchMediaType mediaType = CouchMediaType.fromString((String)response.getMediaType().toString());
        Object content = mediaType.isTextType() ? response.readEntity(String.class) : response.readEntity(byte[].class);
        int contentLength = response.getLength();
        return CouchHttpResponse.builder((CouchMethodType)request.getMethodType(), (URI)uri, (CouchHttpStatus)statusCode).setDocumentId(documentId).setEtag(eTag).setContent(mediaType, contentLength, content).build();
    }
}

