/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api;

import java.lang.reflect.Constructor;
import org.tiogasolutions.couchace.core.api.CouchException;
import org.tiogasolutions.couchace.core.api.injectable.CouchInjectables;
import org.tiogasolutions.couchace.core.api.injectable.MissingInjectableResponse;
import org.tiogasolutions.couchace.core.api.injectable.SimpleCouchInjectables;
import org.tiogasolutions.couchace.core.api.meta.CouchMetaRepository;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpClient;
import org.tiogasolutions.couchace.core.spi.http.SslSetup;
import org.tiogasolutions.couchace.core.spi.json.CouchJsonStrategy;

public class CouchSetup {
    private Class<? extends CouchHttpClient> httpClientClass;
    private Class<? extends CouchJsonStrategy> jsonStrategyClass;
    private CouchHttpClient httpClient;
    private CouchJsonStrategy jsonStrategy;
    private CouchMetaRepository metaRepository = new CouchMetaRepository();
    private CouchInjectables injectables = new SimpleCouchInjectables();
    private MissingInjectableResponse missingInjectableResponse = MissingInjectableResponse.THROW_EXCEPTION;
    private final String url;
    private String userName;
    private String password;
    private SslSetup sslSetup;

    public CouchSetup(String url) {
        this.url = url;
    }

    public CouchSetup ssl(String keyStoreUrl, String storePass) {
        this.sslSetup = new SslSetup(keyStoreUrl, storePass);
        return this;
    }

    public CouchSetup(CouchSetup couchSetup) {
        this.url = couchSetup.getUrl();
        this.userName = couchSetup.getUserName();
        this.password = couchSetup.getPassword();
        this.sslSetup = couchSetup.getSslSetup();
        this.httpClientClass = couchSetup.getHttpClientClass();
        this.jsonStrategyClass = couchSetup.getJsonStrategyClass();
        this.httpClient = couchSetup.getHttpClient();
        this.jsonStrategy = couchSetup.getJsonStrategy();
        this.metaRepository = couchSetup.getMetaRepository();
        this.injectables = couchSetup.getInjectables();
        this.missingInjectableResponse = couchSetup.getMissingInjectableResponse();
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public SslSetup getSslSetup() {
        return this.sslSetup;
    }

    public CouchSetup setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public CouchSetup setPassword(String password) {
        this.password = password;
        return this;
    }

    public CouchSetup setSslSetup(SslSetup sslSetup) {
        this.sslSetup = sslSetup;
        return this;
    }

    public CouchSetup setHttpClient(CouchHttpClient httpClient) {
        this.httpClient = httpClient;
        httpClient.init(this);
        return this;
    }

    public CouchSetup setJsonStrategy(CouchJsonStrategy jsonStrategy) {
        this.jsonStrategy = jsonStrategy;
        jsonStrategy.init(this);
        return this;
    }

    public CouchHttpClient getHttpClient() {
        if (this.httpClient == null) {
            if (this.httpClientClass != null) {
                try {
                    Constructor<? extends CouchHttpClient> constructor = this.httpClientClass.getConstructor(new Class[0]);
                    this.httpClient = constructor.newInstance(new Object[0]);
                    this.httpClient.init(this);
                }
                catch (Exception e) {
                    throw CouchException.internalServerError("Error creating CouchHttpClient.", e);
                }
            } else {
                throw CouchException.internalServerError("No CouchHttpClient instance or class specified.");
            }
        }
        return this.httpClient;
    }

    public CouchJsonStrategy getJsonStrategy() {
        if (this.jsonStrategy == null) {
            if (this.httpClientClass != null) {
                try {
                    Constructor<? extends CouchJsonStrategy> constructor = this.jsonStrategyClass.getConstructor(new Class[0]);
                    this.jsonStrategy = constructor.newInstance(new Object[0]);
                    this.jsonStrategy.init(this);
                }
                catch (Exception e) {
                    throw CouchException.internalServerError("Error creating CouchJsonStrategy.", e);
                }
            } else {
                throw CouchException.internalServerError("No CouchJsonStrategy instance or class specified.");
            }
        }
        return this.jsonStrategy;
    }

    public CouchSetup setHttpClient(Class<? extends CouchHttpClient> httpClientClass) {
        this.httpClientClass = httpClientClass;
        return this;
    }

    public CouchSetup setJsonStrategy(Class<? extends CouchJsonStrategy> jsonStrategyClass) {
        this.jsonStrategyClass = jsonStrategyClass;
        return this;
    }

    public CouchMetaRepository getMetaRepository() {
        return this.metaRepository;
    }

    public CouchSetup setMetaRepository(CouchMetaRepository metaRepository) {
        this.metaRepository = metaRepository;
        return this;
    }

    public CouchInjectables getInjectables() {
        return this.injectables;
    }

    public CouchSetup setInjectables(CouchInjectables injectables) {
        this.injectables = injectables;
        return this;
    }

    public MissingInjectableResponse getMissingInjectableResponse() {
        return this.missingInjectableResponse;
    }

    public CouchSetup setMissingInjectableResponse(MissingInjectableResponse missingInjectableResponse) {
        this.missingInjectableResponse = missingInjectableResponse;
        return this;
    }

    public Class<? extends CouchHttpClient> getHttpClientClass() {
        return this.httpClientClass;
    }

    public Class<? extends CouchJsonStrategy> getJsonStrategyClass() {
        return this.jsonStrategyClass;
    }
}

