/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.http;

public class CouchMediaType {
    private final String type;
    private final String subType;
    private final String fileExtension;
    public static final CouchMediaType UNDEFINED = CouchMediaType.applicationType("undefined");
    public static final CouchMediaType WILDCARD = CouchMediaType.type("*", "*");
    public static final CouchMediaType APPLICATION_XML = CouchMediaType.applicationType("xml");
    public static final CouchMediaType APPLICATION_XHTML = CouchMediaType.applicationType("xhtml+xml", "xhtml");
    public static final CouchMediaType APPLICATION_JSON = CouchMediaType.applicationType("json");
    public static final CouchMediaType APPLICATION_ZIP = CouchMediaType.applicationType("zip");
    public static final CouchMediaType APPLICATION_PDF = CouchMediaType.applicationType("pdf");
    public static final CouchMediaType TEXT_PLAIN = CouchMediaType.textType("plain", "text");
    public static final CouchMediaType TEXT_HTML = CouchMediaType.textType("html");
    public static final CouchMediaType TEXT_XML = CouchMediaType.textType("xml");
    public static final CouchMediaType IMAGE_GIF = CouchMediaType.imageType("gif");
    public static final CouchMediaType IMAGE_JPEG = CouchMediaType.imageType("jpeg");
    public static final CouchMediaType IMAGE_TIFF = CouchMediaType.imageType("tiff");
    public static final CouchMediaType IMAGE_PNG = CouchMediaType.imageType("png");
    public static final CouchMediaType AUDIO_MPEG = CouchMediaType.audioType("mpeg");
    public static final CouchMediaType VIDEO_MP4 = CouchMediaType.videoType("mp4");
    public static final CouchMediaType MULTIPART_MIXED = CouchMediaType.multipartType("mixed");
    public static final CouchMediaType MULTIPART_RELATED = CouchMediaType.multipartType("related");
    public static final CouchMediaType MULTIPART_ALTERNATIVE = CouchMediaType.multipartType("alternative");
    public static final CouchMediaType MULTIPART_FORM_DATA = CouchMediaType.multipartType("form-data");
    public static final CouchMediaType MULTIPART_SIGNED = CouchMediaType.multipartType("signed");
    public static final CouchMediaType MULTIPART_ENCRYPTED = CouchMediaType.multipartType("encrypted");

    public boolean isTextType() {
        return this.getType().equalsIgnoreCase("TEXT") || this.getSubType().equalsIgnoreCase("XML") || this.getSubType().equalsIgnoreCase("XHTML") || this.getSubType().equalsIgnoreCase("JSON");
    }

    public static CouchMediaType newFromJson(String mediaString) {
        return CouchMediaType.fromString(mediaString);
    }

    public static CouchMediaType type(String type, String subType, String fileExtension) {
        fileExtension = fileExtension != null ? fileExtension : subType;
        return new CouchMediaType(type, subType, fileExtension);
    }

    public static CouchMediaType fromString(String mediaString) {
        String[] split = mediaString.split("/");
        if (split.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid mime type value: %s", mediaString));
        }
        return CouchMediaType.type(split[0], split[1]);
    }

    public static CouchMediaType type(String type, String subType) {
        return CouchMediaType.type(type, subType, subType);
    }

    public static CouchMediaType applicationType(String subType) {
        return CouchMediaType.type("application", subType);
    }

    public static CouchMediaType applicationType(String subType, String fileExtension) {
        return CouchMediaType.type("application", subType, fileExtension);
    }

    public static CouchMediaType multipartType(String subType) {
        return CouchMediaType.type("multipart", subType);
    }

    public static CouchMediaType textType(String subType, String fileExtension) {
        return CouchMediaType.type("text", subType, fileExtension);
    }

    public static CouchMediaType textType(String subType) {
        return CouchMediaType.type("text", subType);
    }

    public static CouchMediaType imageType(String subType, String fileExtension) {
        return CouchMediaType.type("image", subType, fileExtension);
    }

    public static CouchMediaType imageType(String subType) {
        return CouchMediaType.type("image", subType);
    }

    public static CouchMediaType messageType(String subType, String fileExtension) {
        return CouchMediaType.type("message", subType, fileExtension);
    }

    public static CouchMediaType audioType(String subType, String fileExtension) {
        return CouchMediaType.type("audio", subType, fileExtension);
    }

    public static CouchMediaType audioType(String subType) {
        return CouchMediaType.type("audio", subType);
    }

    public static CouchMediaType videoType(String subType, String fileExtension) {
        return CouchMediaType.type("text", subType, fileExtension);
    }

    public static CouchMediaType videoType(String subType) {
        return CouchMediaType.type("text", subType);
    }

    private CouchMediaType(String type, String subType, String fileExtension) {
        if (type == null) {
            throw new NullPointerException("Null type argument give to HttpMediaType.");
        }
        if (subType == null) {
            throw new NullPointerException("Null subType argument give to HttpMediaType.");
        }
        if (fileExtension == null) {
            throw new NullPointerException("Null fileExtension argument give to HttpMediaType.");
        }
        this.type = type;
        this.subType = subType;
        this.fileExtension = fileExtension;
    }

    public String getMediaString() {
        return String.format("%s/%s", this.type, this.subType);
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public boolean isUndefined() {
        return this.equals(UNDEFINED);
    }

    public boolean isDefined() {
        return !this.equals(UNDEFINED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CouchMediaType contentMediaType = (CouchMediaType)o;
        if (!this.subType.equals(contentMediaType.subType)) {
            return false;
        }
        return this.type.equals(contentMediaType.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subType.hashCode();
        result = 31 * result + this.fileExtension.hashCode();
        return result;
    }

    public String toString() {
        return this.getMediaString();
    }
}

