/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.request;

import org.tiogasolutions.couchace.core.api.request.DeleteRequest;
import org.tiogasolutions.couchace.core.api.response.CouchResponseHandler;
import org.tiogasolutions.couchace.core.api.response.WriteResponse;
import org.tiogasolutions.couchace.core.internal.RequestExecutor;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;

public class DeleteDocumentRequest
implements DeleteRequest {
    private final RequestExecutor requestExecutor;
    private final Type type;
    private final String documentId;
    private final String documentRevision;
    private CouchResponseHandler<WriteResponse> onResponse;
    private CouchResponseHandler<WriteResponse> onSuccess;
    private CouchResponseHandler<WriteResponse> onError;

    public static DeleteDocumentRequest document(RequestExecutor requestExecutor, String documentId, String documentRevision) {
        ArgUtil.assertNotNull(documentId, "documentId");
        ArgUtil.assertNotNull(documentRevision, "documentRevision");
        return new DeleteDocumentRequest(requestExecutor, Type.DOCUMENT, documentId, documentRevision);
    }

    public static DeleteDocumentRequest database(RequestExecutor requestExecutor) {
        return new DeleteDocumentRequest(requestExecutor, Type.DATABASE, null, null);
    }

    public static DeleteDocumentRequest allDesigns(RequestExecutor requestExecutor) {
        return new DeleteDocumentRequest(requestExecutor, Type.ALL_DESIGNS, null, null);
    }

    public static DeleteDocumentRequest allDocuments(RequestExecutor requestExecutor) {
        return new DeleteDocumentRequest(requestExecutor, Type.ALL_DOCUMENTS, null, null);
    }

    public static DeleteDocumentRequest allNonDesigns(RequestExecutor requestExecutor) {
        return new DeleteDocumentRequest(requestExecutor, Type.ALL_NON_DESIGNS, null, null);
    }

    public DeleteDocumentRequest(RequestExecutor requestExecutor, Type type, String documentId, String documentRevision) {
        this.requestExecutor = requestExecutor;
        this.type = type;
        this.documentId = documentId;
        this.documentRevision = documentRevision;
    }

    public Type getType() {
        return this.type;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getDocumentRevision() {
        return this.documentRevision;
    }

    public boolean hasRevision() {
        return this.documentRevision != null;
    }

    public WriteResponse execute() {
        return this.requestExecutor.execute(this);
    }

    public DeleteDocumentRequest onResponse(CouchResponseHandler<WriteResponse> onResponse) {
        this.onResponse = onResponse;
        return this;
    }

    public DeleteDocumentRequest onSuccess(CouchResponseHandler<WriteResponse> onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public DeleteDocumentRequest onError(CouchResponseHandler<WriteResponse> onError) {
        this.onError = onError;
        return this;
    }

    public CouchResponseHandler<WriteResponse> getOnResponse() {
        return this.onResponse;
    }

    public CouchResponseHandler<WriteResponse> getOnSuccess() {
        return this.onSuccess;
    }

    public CouchResponseHandler<WriteResponse> getOnError() {
        return this.onError;
    }

    public static enum Type {
        DATABASE,
        DOCUMENT,
        ALL_DESIGNS,
        ALL_DOCUMENTS,
        ALL_NON_DESIGNS;

    }
}

