/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.request;

import org.tiogasolutions.couchace.core.api.query.CouchPageQuery;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.couchace.core.api.request.ReadRequest;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;

public abstract class ReadDocumentRequest
implements ReadRequest {
    private final String documentId;
    private final String documentRevision;
    private final CouchViewQuery viewQuery;
    private final CouchPageQuery pageQuery;

    protected ReadDocumentRequest(String documentId, String documentRevision) {
        ArgUtil.assertNotNull(documentId, "documentId");
        this.documentId = documentId;
        this.documentRevision = documentRevision;
        this.viewQuery = null;
        this.pageQuery = null;
    }

    protected ReadDocumentRequest(CouchViewQuery viewQuery) {
        ArgUtil.assertNotNull(viewQuery, "viewQuery");
        this.viewQuery = viewQuery;
        this.documentId = null;
        this.documentRevision = null;
        this.pageQuery = null;
    }

    protected ReadDocumentRequest(CouchPageQuery pageQuery) {
        ArgUtil.assertNotNull(pageQuery, "pageQuery");
        this.pageQuery = pageQuery;
        this.viewQuery = null;
        this.documentId = null;
        this.documentRevision = null;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getDocumentRevision() {
        return this.documentRevision;
    }

    public CouchPageQuery getPageQuery() {
        return this.pageQuery;
    }

    public CouchViewQuery getViewQuery() {
        return this.viewQuery;
    }
}

