/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.spi.http;

import java.net.URI;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.http.CouchMethodType;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpResponse;

public class CouchHttpResponseBuilder {
    private final URI uri;
    private final CouchHttpStatus httpStatus;
    private final CouchMethodType methodType;
    private String documentId;
    private String etag;
    private CouchMediaType contentType;
    private int contentLength;
    private Object content;

    public CouchHttpResponseBuilder(CouchMethodType methodType, URI uri, CouchHttpStatus httpStatus) {
        ArgUtil.assertNotNull((Object)methodType, "HttpMethodType");
        ArgUtil.assertNotNull(uri, "URI");
        ArgUtil.assertNotNull((Object)httpStatus, "HttpStatus");
        this.uri = uri;
        this.httpStatus = httpStatus;
        this.methodType = methodType;
    }

    public CouchHttpResponse build() {
        return new CouchHttpResponse(this.methodType, this.uri, this.httpStatus, this.documentId, this.etag, this.contentType, this.content);
    }

    public CouchHttpResponseBuilder setContent(CouchMediaType mediaType, int contentLength, Object content) {
        this.contentType = mediaType;
        this.contentLength = contentLength;
        this.content = content;
        return this;
    }

    public CouchHttpResponseBuilder setErrorContent(CouchErrorContent errorContent) {
        this.contentType = CouchMediaType.APPLICATION_JSON;
        String json = errorContent.toJson();
        this.content = json;
        this.contentLength = json.length();
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public CouchHttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public CouchHttpResponseBuilder setDocumentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    public String getEtag() {
        return this.etag;
    }

    public CouchHttpResponseBuilder setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public CouchMediaType getContentType() {
        return this.contentType;
    }

    public Object getContent() {
        return this.content;
    }

    public CouchMethodType getMethodType() {
        return this.methodType;
    }

    public int getContentLength() {
        return this.contentLength;
    }
}

