/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import org.thymeleaf.context.IContextVariableRestriction;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForbiddenContextVariableRestriction
implements IContextVariableRestriction {
    private final String targetVariableName;
    private final String message;

    public ForbiddenContextVariableRestriction(String targetVariableName) {
        this(targetVariableName, null);
    }

    public ForbiddenContextVariableRestriction(String targetVariableName, String message) {
        Validate.notNull(targetVariableName, "Variable name cannot be null");
        this.targetVariableName = targetVariableName;
        this.message = message;
    }

    @Override
    public void checkAccess(VariablesMap<?, ?> variablesMap, String variableName) {
        if (!this.targetVariableName.equals(variableName)) {
            return;
        }
        String exceptionMessage = this.message != null ? this.message : "Access to variable \"" + variableName + "\" is forbidden in this context";
        throw new TemplateProcessingException(exceptionMessage);
    }
}

