/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.doctype.resolution;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.thymeleaf.doctype.DocTypeIdentifier;
import org.thymeleaf.doctype.resolution.IDocTypeResolutionEntry;
import org.thymeleaf.util.Validate;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ServletContextDocTypeResolutionEntry
implements IDocTypeResolutionEntry {
    private final DocTypeIdentifier systemID;
    private final DocTypeIdentifier publicID;
    private final ServletContext servletContext;
    private final String resourcePath;

    public ServletContextDocTypeResolutionEntry(DocTypeIdentifier publicID, DocTypeIdentifier systemID, ServletContext servletContext, String resourcePath) {
        Validate.notNull(servletContext, "Servlet context cannot be null");
        Validate.notNull(resourcePath, "Resource path cannot be null");
        this.publicID = publicID;
        this.systemID = systemID;
        this.servletContext = servletContext;
        this.resourcePath = resourcePath;
    }

    public DocTypeIdentifier getSystemID() {
        return this.systemID;
    }

    public DocTypeIdentifier getPublicID() {
        return this.publicID;
    }

    public InputSource createInputSource() throws SAXException, IOException {
        return new InputSource(this.servletContext.getResourceAsStream(this.resourcePath));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.publicID == null ? 0 : this.publicID.hashCode());
        result = 31 * result + (this.resourcePath == null ? 0 : this.resourcePath.hashCode());
        result = 31 * result + (this.servletContext == null ? 0 : this.servletContext.hashCode());
        result = 31 * result + (this.systemID == null ? 0 : this.systemID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServletContextDocTypeResolutionEntry other = (ServletContextDocTypeResolutionEntry)obj;
        if (this.publicID == null ? other.publicID != null : !this.publicID.equals(other.publicID)) {
            return false;
        }
        if (this.resourcePath == null ? other.resourcePath != null : !this.resourcePath.equals(other.resourcePath)) {
            return false;
        }
        if (this.servletContext == null ? other.servletContext != null : !this.servletContext.equals(other.servletContext)) {
            return false;
        }
        return !(this.systemID == null ? other.systemID != null : !this.systemID.equals(other.systemID));
    }
}

