/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Node;
import org.thymeleaf.util.Validate;
import org.unbescape.html.HtmlEscape;

public abstract class AbstractTextNode
extends Node {
    private static final long serialVersionUID = -4406245492696671750L;
    boolean contentIsEscaped;
    String content;

    @Deprecated
    AbstractTextNode(String content, boolean escapeXml, String documentName, Integer lineNumber) {
        super(documentName, lineNumber);
        Validate.notNull(content, "Content cannot be null");
        if (escapeXml) {
            this.content = HtmlEscape.escapeHtml4Xml((String)content);
            this.contentIsEscaped = true;
        } else {
            this.content = content;
            this.contentIsEscaped = false;
        }
    }

    AbstractTextNode(String content, String documentName, Integer lineNumber, boolean contentIsEscaped) {
        super(documentName, lineNumber);
        Validate.notNull(content, "Content cannot be null");
        this.content = content;
        this.contentIsEscaped = contentIsEscaped;
    }

    public String getContent() {
        if (this.contentIsEscaped) {
            return HtmlEscape.unescapeHtml((String)this.content);
        }
        return this.content;
    }

    public String getEscapedContent() {
        if (this.contentIsEscaped) {
            return this.content;
        }
        return HtmlEscape.escapeHtml4Xml((String)this.content);
    }

    public String getOriginalContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.contentIsEscaped = false;
    }

    public void setContent(String content, boolean contentIsEscaped) {
        this.content = content;
        this.contentIsEscaped = contentIsEscaped;
    }

    final void doAdditionalSkippableComputing(boolean skippable) {
    }

    final void doAdditionalProcessableComputing(boolean processable) {
    }

    final void doAdditionalPrecomputeNode(Configuration configuration) {
    }

    final void doAdditionalProcess(Arguments arguments) {
    }
}

