/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.fragment;

import java.util.List;
import org.thymeleaf.Configuration;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dom.DOMSelector;
import org.thymeleaf.dom.Node;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMSelectorFragmentSpec
implements IFragmentSpec {
    public static final String DOM_SELECTOR_EXPRESSION_PREFIX = "{dom_selector}";
    private final String selectorExpression;
    private final DOMSelector.INodeReferenceChecker referenceChecker;
    private final String domSelectorCacheKey;

    public DOMSelectorFragmentSpec(String selectorExpression) {
        this(selectorExpression, null);
    }

    public DOMSelectorFragmentSpec(String selectorExpression, DOMSelector.INodeReferenceChecker referenceChecker) {
        Validate.notEmpty(selectorExpression, "DOM selector expression cannot be null or empty");
        this.selectorExpression = selectorExpression;
        this.referenceChecker = referenceChecker;
        this.domSelectorCacheKey = DOMSelectorFragmentSpec.generateDOMSelectorCacheKey(this.selectorExpression);
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    public DOMSelector.INodeReferenceChecker getReferenceChecker() {
        return this.referenceChecker;
    }

    @Override
    public final List<Node> extractFragment(Configuration configuration, List<Node> nodes) {
        List<Node> extraction;
        DOMSelector selector = null;
        ICache<String, Object> expressionCache = null;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (expressionCache = cacheManager.getExpressionCache()) != null) {
            selector = (DOMSelector)expressionCache.get(this.domSelectorCacheKey);
        }
        if (selector == null) {
            selector = new DOMSelector(this.selectorExpression);
            if (expressionCache != null) {
                expressionCache.put(this.domSelectorCacheKey, selector);
            }
        }
        if ((extraction = selector.select(nodes, this.referenceChecker)) == null || extraction.size() == 0) {
            return null;
        }
        return extraction;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("(DOMSELECTOR: ");
        strBuilder.append(this.selectorExpression);
        if (this.referenceChecker != null) {
            strBuilder.append(" | ");
            strBuilder.append(this.referenceChecker.getClass().getName());
        }
        strBuilder.append(")");
        return strBuilder.toString();
    }

    private static String generateDOMSelectorCacheKey(String selectorExpression) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(DOM_SELECTOR_EXPRESSION_PREFIX);
        strBuilder.append(selectorExpression);
        return strBuilder.toString();
    }
}

