/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.attr;

import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributeModifierAttrProcessor
extends AbstractAttrProcessor {
    protected AbstractAttributeModifierAttrProcessor(String attributeName) {
        super(attributeName);
    }

    protected AbstractAttributeModifierAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public final ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        Map<String, String> modifiedAttributeValues = this.getModifiedAttributeValues(arguments, element, attributeName);
        if (modifiedAttributeValues == null) {
            throw new TemplateProcessingException("Null new attribute value map specified for: \"" + attributeName + "\"");
        }
        for (Map.Entry<String, String> modifiedAttributeEntry : modifiedAttributeValues.entrySet()) {
            String modifiedAttributeName = modifiedAttributeEntry.getKey();
            String oldAttributeValue = element.getAttributeValue(modifiedAttributeName);
            String newAttributeValue = modifiedAttributeEntry.getValue();
            ModificationType modificationType = this.getModificationType(arguments, element, attributeName, modifiedAttributeName);
            newAttributeValue = AbstractAttributeModifierAttrProcessor.defaultToNull(newAttributeValue);
            switch (modificationType) {
                case SUBSTITUTION: {
                    break;
                }
                case APPEND_WITH_SPACE: {
                    if (newAttributeValue != null && oldAttributeValue != null && oldAttributeValue.length() != 0) {
                        newAttributeValue = ' ' + newAttributeValue;
                    }
                }
                case APPEND: {
                    if (newAttributeValue == null) {
                        newAttributeValue = oldAttributeValue;
                        break;
                    }
                    newAttributeValue = AbstractAttributeModifierAttrProcessor.defaultToEmpty(oldAttributeValue) + newAttributeValue;
                    break;
                }
                case PREPEND_WITH_SPACE: {
                    if (newAttributeValue != null && oldAttributeValue != null && oldAttributeValue.length() != 0) {
                        newAttributeValue = newAttributeValue + ' ';
                    }
                }
                case PREPEND: {
                    newAttributeValue = newAttributeValue == null ? oldAttributeValue : newAttributeValue + AbstractAttributeModifierAttrProcessor.defaultToEmpty(oldAttributeValue);
                }
            }
            boolean removeAttributeIfEmpty = this.removeAttributeIfEmpty(arguments, element, attributeName, modifiedAttributeName);
            if (removeAttributeIfEmpty && newAttributeValue == null) {
                element.removeAttribute(modifiedAttributeName);
                continue;
            }
            element.setAttribute(modifiedAttributeName, AbstractAttributeModifierAttrProcessor.defaultToEmpty(newAttributeValue));
        }
        this.doAdditionalProcess(arguments, element, attributeName);
        if (this.shouldRemoveAttribute(arguments, element, attributeName)) {
            element.removeAttribute(attributeName);
        }
        if (this.recomputeProcessorsAfterExecution(arguments, element, attributeName)) {
            element.setRecomputeProcessorsImmediately(true);
        }
        return ProcessorResult.OK;
    }

    private static String defaultToEmpty(String str) {
        return str == null ? "" : str;
    }

    private static String defaultToNull(String str) {
        return str != null && str.length() == 0 ? null : str;
    }

    protected abstract Map<String, String> getModifiedAttributeValues(Arguments var1, Element var2, String var3);

    protected abstract ModificationType getModificationType(Arguments var1, Element var2, String var3, String var4);

    protected abstract boolean removeAttributeIfEmpty(Arguments var1, Element var2, String var3, String var4);

    protected abstract boolean recomputeProcessorsAfterExecution(Arguments var1, Element var2, String var3);

    protected void doAdditionalProcess(Arguments arguments, Element element, String attributeName) {
    }

    protected boolean shouldRemoveAttribute(Arguments arguments, Element element, String attributeName) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModificationType {
        SUBSTITUTION,
        APPEND,
        APPEND_WITH_SPACE,
        PREPEND,
        PREPEND_WITH_SPACE;

    }
}

