/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.app.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.app.common.AppUtils;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;

public class AppPathResolver {
    private static final Logger log = LoggerFactory.getLogger(AppUtils.class);
    private final String springPropertyName;
    private final String configPropertyName;
    private final String runtimePropertyName;
    private final String profilesPropertyName;

    public AppPathResolver(String prefix) {
        this.springPropertyName = prefix + "spring.config";
        this.configPropertyName = prefix + " config.dir";
        this.runtimePropertyName = prefix + "runtime.dir";
        this.profilesPropertyName = prefix + "active.profiles";
    }

    public Path requireRuntimePath() throws FileNotFoundException {
        return this.resolveRuntimePath("runtime", true);
    }

    public Path requireRuntimePath(String directoryName) throws FileNotFoundException {
        return this.resolveRuntimePath(directoryName, true);
    }

    public Path resolveRuntimePath() throws FileNotFoundException {
        return this.resolveRuntimePath("runtime");
    }

    public Path resolveRuntimePath(String directoryName) throws FileNotFoundException {
        return this.resolveRuntimePath(directoryName, false);
    }

    public Path resolveRuntimePath(String directoryName, boolean required) throws FileNotFoundException {
        String msg;
        Path runtimeDir;
        ExceptionUtils.assertNotNull((Object)directoryName, (String)"directoryName");
        String runtimeDirArg = EnvUtils.findProperty((String)this.runtimePropertyName);
        if (runtimeDirArg == null) {
            File currentDir = IoUtils.currentDir();
            File moduleDir = IoUtils.findDirNear((File)currentDir, (String)directoryName);
            if (moduleDir == null) {
                if (!required) {
                    return null;
                }
                String msg2 = String.format("The runtime directory (%s) was not found relative to the current directory (%s). Please change the working directory or specify the system property or environment variable %s.", directoryName, currentDir, this.runtimePropertyName);
                throw new FileNotFoundException(msg2);
            }
            runtimeDirArg = moduleDir.getAbsolutePath();
        }
        if (Files.notExists(runtimeDir = Paths.get(runtimeDirArg, new String[0]).toAbsolutePath(), new LinkOption[0])) {
            if (!required) {
                return null;
            }
            msg = String.format("Runtime directory %s does not exist", runtimeDir);
            throw new FileNotFoundException(msg);
        }
        if (!Files.isDirectory(runtimeDir, new LinkOption[0])) {
            msg = String.format("Runtime directory %s is not a directory", runtimeDir);
            throw new IllegalArgumentException(msg);
        }
        System.setProperty(this.runtimePropertyName, runtimeDir.toString());
        log.info("Runtime dir: {}", (Object)runtimeDir);
        return runtimeDir;
    }

    public Path requireConfigDir(Path runtimeDir) throws FileNotFoundException {
        return this.resolveConfigDir(runtimeDir, "config", true);
    }

    public Path requireConfigDir(Path runtimeDir, String directoryName) throws FileNotFoundException {
        return this.resolveConfigDir(runtimeDir, directoryName, true);
    }

    public Path resolveConfigDir(Path runtimeDir) throws FileNotFoundException {
        return this.resolveConfigDir(runtimeDir, "config", false);
    }

    public Path resolveConfigDir(Path runtimeDir, String directoryName) throws FileNotFoundException {
        return this.resolveConfigDir(runtimeDir, directoryName, false);
    }

    public Path resolveConfigDir(Path runtimeDir, String directoryName, boolean required) throws FileNotFoundException {
        ExceptionUtils.assertNotNull((Object)directoryName, (String)"directoryName");
        if (runtimeDir == null || !Files.exists(runtimeDir, new LinkOption[0])) {
            if (!required) {
                return null;
            }
            throw new IllegalArgumentException("Runtime directory required to resolve config directory.");
        }
        Path configDir = runtimeDir.resolve(directoryName);
        if (Files.notExists(configDir, new LinkOption[0])) {
            if (!required) {
                return null;
            }
            String msg = String.format("Config directory %s does not exist", configDir);
            throw new FileNotFoundException(msg);
        }
        if (!Files.isDirectory(runtimeDir, new LinkOption[0])) {
            String msg = String.format("Config directory %s is not a directory", configDir);
            throw new IllegalArgumentException(msg);
        }
        System.setProperty(this.configPropertyName, configDir.toString());
        log.info("Config dir: {}", (Object)configDir);
        return configDir;
    }

    public String resolveSpringPath(Path configDir, String internalFile) throws FileNotFoundException {
        return this.resolveSpringPath(configDir, "spring-config.xml", internalFile);
    }

    public String resolveSpringPath(Path configDir, String fileName, String internalFile) throws FileNotFoundException {
        String springConfigPath;
        ExceptionUtils.assertNotNull((Object)fileName, (String)"fileName");
        String springFileName = EnvUtils.findProperty((String)this.springPropertyName);
        if (springFileName != null) {
            Path springConfig = Paths.get(springFileName, new String[0]);
            if (!springConfig.isAbsolute()) {
                if (configDir == null) {
                    String msg = String.format("The config directory must be specified for relative spring files (%s).", springFileName);
                    throw new IllegalArgumentException(msg);
                }
                springConfig = configDir.resolve(springFileName);
            }
            if (Files.notExists(springConfig, new LinkOption[0])) {
                String msg = "The specified spring config file does not exist: " + springConfig;
                throw new FileNotFoundException(msg);
            }
            springConfigPath = springConfig.toUri().toString();
            log.info("Spring file: {}", (Object)springConfigPath);
            log.info("  Using the specified spring config file");
        } else {
            Path springConfig;
            Path path = springConfig = configDir == null ? null : configDir.resolve(fileName);
            if (configDir != null && springConfig.toFile().exists()) {
                springConfigPath = springConfig.toUri().toString();
                log.info("Spring file: {}", (Object)springConfigPath);
                log.info("  Using the external spring config file");
            } else {
                springConfigPath = internalFile;
                log.info("Spring file: {}", (Object)springConfigPath);
                log.info("  Using the internal spring config file");
                log.info("  Override by using the external spring config file: {}", (Object)springConfig);
                log.info("  Override by specifying the location of the external spring config file with the system property \"{}\"", (Object)this.springPropertyName);
            }
        }
        System.setProperty(this.springPropertyName, springConfigPath);
        return springConfigPath;
    }

    public String resolveSpringProfiles() {
        return this.resolveSpringProfiles("hosted");
    }

    public String resolveSpringProfiles(String additionalProfiles) {
        String activeProfiles = EnvUtils.findProperty((String)this.profilesPropertyName, (String)"");
        if (StringUtils.isNotBlank((Object)activeProfiles)) {
            activeProfiles = activeProfiles + ",";
        }
        activeProfiles = activeProfiles + additionalProfiles;
        System.setProperty(this.profilesPropertyName, activeProfiles);
        log.info("Active spring profiles: {}", (Object)activeProfiles);
        return activeProfiles;
    }
}

