/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.process;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import jersey.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.glassfish.jersey.process.internal.RequestExecutorFactory;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.spi.RequestExecutorProvider;

class ServerManagedAsyncExecutorFactory
extends RequestExecutorFactory
implements ContainerLifecycleListener {
    @Inject
    public ServerManagedAsyncExecutorFactory(ServiceLocator locator) {
        super(locator, new Object[0]);
    }

    protected RequestExecutorProvider getDefaultProvider(Object ... initArgs) {
        return new RequestExecutorProvider(){

            public ExecutorService getRequestingExecutor() {
                return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("jersey-server-managed-async-executor-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).build());
            }

            public void releaseRequestingExecutor(ExecutorService executor) {
                executor.shutdownNow();
            }
        };
    }

    @Override
    public void onStartup(Container container) {
    }

    @Override
    public void onReload(Container container) {
    }

    @Override
    public void onShutdown(Container container) {
        this.close();
    }
}

