/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class LocalTimeSerializer
extends JSR310FormattedSerializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalTimeSerializer INSTANCE = new LocalTimeSerializer();

    private LocalTimeSerializer() {
        this(null, null);
    }

    private LocalTimeSerializer(Boolean useTimestamp, DateTimeFormatter dtf) {
        super(LocalTime.class, useTimestamp, dtf);
    }

    @Override
    protected JSR310FormattedSerializerBase<LocalTime> withFormat(Boolean useTimestamp, DateTimeFormatter dtf) {
        return new LocalTimeSerializer(useTimestamp, dtf);
    }

    public void serialize(LocalTime time, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            generator.writeStartArray();
            generator.writeNumber(time.getHour());
            generator.writeNumber(time.getMinute());
            if (time.getSecond() > 0 || time.getNano() > 0) {
                generator.writeNumber(time.getSecond());
                if (time.getNano() > 0) {
                    if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                        generator.writeNumber(time.getNano());
                    } else {
                        generator.writeNumber(time.get(ChronoField.MILLI_OF_SECOND));
                    }
                }
            }
            generator.writeEndArray();
        } else {
            String str = this._formatter == null ? time.toString() : time.format(this._formatter);
            generator.writeString(str);
        }
    }
}

