/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.notification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tiogasolutions.notify.pub.notification.NotificationRef;

public final class CreateAttachment {
    private final NotificationRef notificationRef;
    private final String attachmentName;
    private final String contentType;
    private final InputStream inputStream;

    public CreateAttachment(NotificationRef notificationRef, String attachmentName, String contentType, InputStream inputStream) {
        this.notificationRef = notificationRef;
        this.attachmentName = attachmentName != null ? attachmentName : "no name";
        this.contentType = contentType != null ? contentType : "unknown";
        this.inputStream = inputStream;
    }

    public CreateAttachment(NotificationRef notificationRef, String attachmentName, String contentType, byte[] content) {
        this(notificationRef, attachmentName, contentType, new ByteArrayInputStream(content));
    }

    public NotificationRef getNotificationRef() {
        return this.notificationRef;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void dispose() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

