/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.notification;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.notify.pub.common.ExceptionInfo;
import org.tiogasolutions.notify.pub.common.Link;

public class CreateNotification {
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final Map<String, String> traitMap;
    private final List<Link> links;
    private final ExceptionInfo exceptionInfo;

    public CreateNotification(@JsonProperty(value="topic") String topic, @JsonProperty(value="summary") String summary, @JsonProperty(value="trackingId") String trackingId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="exceptionInfo") ExceptionInfo exceptionInfo, @JsonProperty(value="links") List<Link> links, @JsonProperty(value="traitMap") Map<String, String> traitMap) {
        this.topic = topic;
        this.summary = summary;
        this.trackingId = trackingId;
        this.createdAt = createdAt != null ? createdAt : ZonedDateTime.now();
        this.exceptionInfo = exceptionInfo;
        this.links = links != null ? Collections.unmodifiableList(links) : Collections.emptyList();
        HashMap<String, String> localMap = new HashMap<String, String>();
        if (traitMap != null) {
            for (Map.Entry<String, String> trait : traitMap.entrySet()) {
                if (trait.getKey() == null) continue;
                localMap.put(trait.getKey().toLowerCase(), trait.getValue());
            }
        }
        this.traitMap = localMap;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateNotification that = (CreateNotification)o;
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.exceptionInfo != null ? !this.exceptionInfo.equals((Object)that.exceptionInfo) : that.exceptionInfo != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(that.summary) : that.summary != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.trackingId != null ? !this.trackingId.equals(that.trackingId) : that.trackingId != null) {
            return false;
        }
        return !(this.traitMap != null ? !this.traitMap.equals(that.traitMap) : that.traitMap != null);
    }

    public int hashCode() {
        int result = this.topic != null ? this.topic.hashCode() : 0;
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.trackingId != null ? this.trackingId.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.traitMap != null ? this.traitMap.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.exceptionInfo != null ? this.exceptionInfo.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CreateNotification{topic='" + this.topic + '\'' + ", summary='" + this.summary + '\'' + ", trackingId='" + this.trackingId + '\'' + ", createdAt=" + this.createdAt + ", traitMap=" + this.traitMap + ", links=" + this.links + ", exceptionInfo=" + this.exceptionInfo + '}';
    }
}

