/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.notification;

import java.util.Set;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.notification.CreateAttachment;
import org.tiogasolutions.notify.kernel.notification.CreateNotification;
import org.tiogasolutions.notify.kernel.notification.NotificationEntity;
import org.tiogasolutions.notify.kernel.notification.NotificationStore;
import org.tiogasolutions.notify.kernel.route.JsRouteEvaluator;
import org.tiogasolutions.notify.kernel.route.RouteEvaluator;
import org.tiogasolutions.notify.kernel.task.CreateTask;
import org.tiogasolutions.notify.kernel.task.TaskEntity;
import org.tiogasolutions.notify.kernel.task.TaskGenerator;
import org.tiogasolutions.notify.kernel.task.TaskStore;
import org.tiogasolutions.notify.pub.attachment.AttachmentHolder;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.notification.NotificationQuery;
import org.tiogasolutions.notify.pub.notification.NotificationRef;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.notify.pub.route.RouteCatalog;
import org.tiogasolutions.notify.pub.task.TaskQuery;

public class NotificationDomain {
    private final String domainName;
    private final TaskGenerator taskGenerator;
    private final EventBus eventBus;
    private final NotificationStore notificationStore;
    private final TaskStore taskStore;
    private final RouteEvaluator routeEvaluator;

    public NotificationDomain(String domainName, CouchDatabase couchDatabase, RouteCatalog routeCatalog, TaskGenerator taskGenerator, EventBus eventBus) {
        this.domainName = domainName;
        this.taskGenerator = taskGenerator;
        this.eventBus = eventBus;
        this.notificationStore = new NotificationStore(couchDatabase);
        this.taskStore = new TaskStore(couchDatabase);
        this.routeEvaluator = new JsRouteEvaluator(routeCatalog);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public RouteEvaluator getRouteEvaluator() {
        return this.routeEvaluator;
    }

    public Set<Destination> findDestinations(Notification notification) {
        return this.getRouteEvaluator().findDestinations(notification);
    }

    public NotificationRef createNotification(CreateNotification create) {
        ExceptionUtils.assertNotNull((Object)create, (String)"create");
        NotificationEntity entity = NotificationEntity.newEntity(this.getDomainName(), create);
        Notification notification = this.notificationStore.saveAndReload(entity).toNotification();
        this.taskGenerator.generateTasks(this, notification);
        return notification.toNotificationRef();
    }

    public NotificationEntity findNotificationById(String notificationId) {
        return this.notificationStore.findNotificationById(notificationId);
    }

    public QueryResult<Notification> query(NotificationQuery query) {
        return this.notificationStore.query(query);
    }

    public NotificationRef createAttachment(CreateAttachment create) {
        return this.notificationStore.createAttachment(create);
    }

    public AttachmentHolder findAttachment(String notificationId, String attachmentName) {
        return this.notificationStore.findAttachment(notificationId, attachmentName);
    }

    public void deleteNotification(String notificationId) {
        this.notificationStore.deleteNotification(notificationId);
    }

    public TaskEntity findTaskById(String entityId) {
        return this.taskStore.findTaskById(entityId);
    }

    public ListQueryResult<TaskEntity> query(TaskQuery query) {
        return this.taskStore.query(query);
    }

    public TaskEntity createTask(CreateTask create, Notification notification) {
        TaskEntity taskEntity = this.taskStore.createTask(create);
        this.eventBus.taskCreated(this.domainName, taskEntity, notification);
        return taskEntity;
    }

    public void save(TaskEntity entity) {
        this.taskStore.save(entity);
    }

    public TaskEntity saveAndReload(TaskEntity entity) {
        return this.taskStore.saveAndReload(entity);
    }

    public void deleteTask(String taskId) {
        this.taskStore.deleteTask(taskId);
    }
}

