/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.task;

import java.util.HashMap;
import java.util.Map;

public class TaskProcessorType {
    private static Map<String, TaskProcessorType> map = new HashMap<String, TaskProcessorType>();
    private final String code;

    public static boolean isValueOf(String code) {
        return map.containsKey(code);
    }

    public static boolean isNotValueOf(String code) {
        return !map.containsKey(code);
    }

    public static TaskProcessorType valueOf(String code) throws IllegalArgumentException {
        if (!map.containsKey(code)) {
            String msg = String.format("The processor type \"%s\" was not found.%n", code);
            throw new IllegalArgumentException(msg);
        }
        return map.get(code);
    }

    public TaskProcessorType(String code) {
        this.code = code;
        map.put(code, this);
    }

    public String getCode() {
        return this.code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskProcessorType that = (TaskProcessorType)o;
        return !(this.code != null ? !this.code.equals(that.code) : that.code != null);
    }

    public int hashCode() {
        return this.code != null ? this.code.hashCode() : 0;
    }

    public String toString() {
        return this.code;
    }
}

