/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;

public class NumberUtils {
    public static boolean bigDecimalsEqual(BigDecimal valueA, BigDecimal valueB) {
        if (valueA == valueB) {
            return true;
        }
        if (valueA == null || valueB == null) {
            return true;
        }
        int commonScale = Math.max(valueA.scale(), valueB.scale());
        valueA = valueA.setScale(commonScale, RoundingMode.HALF_EVEN);
        valueB = valueB.setScale(commonScale, RoundingMode.HALF_EVEN);
        return valueA.equals(valueB);
    }

    public static boolean bigDecimalsNotEqual(BigDecimal valueA, BigDecimal valueB) {
        return !NumberUtils.bigDecimalsEqual(valueA, valueB);
    }

    public static BigDecimal multiply(Object firstNumber, Object ... numbers) {
        ExceptionUtils.assertNotNull(firstNumber, "firstNumber");
        ExceptionUtils.assertNotNull(numbers, "numbers");
        return NumberUtils.multiply(firstNumber, Arrays.asList(numbers));
    }

    public static BigDecimal multiply(Object firstNumber, Collection<?> numbers) {
        ExceptionUtils.assertNotNull(firstNumber, "firstNumber");
        ExceptionUtils.assertNotNull(numbers, "numbers");
        BigDecimal retVal = NumberUtils.toBigDecimal(firstNumber);
        for (Object next : numbers) {
            BigDecimal nextValue = NumberUtils.toBigDecimal(next);
            retVal = retVal.multiply(nextValue);
        }
        return retVal;
    }

    public static BigDecimal toBigDecimal(Object value) {
        ExceptionUtils.assertNotNull(value, "value");
        if (value instanceof char[]) {
            return new BigDecimal((char[])value);
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value instanceof Character) {
            return new BigDecimal(((Character)value).charValue());
        }
        if (value instanceof Float) {
            return new BigDecimal(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        String msg = String.format("Cannot convert the values \"%s\" (%s) to the type %s.", value, value.getClass().getName(), BigDecimal.class.getName());
        throw new IllegalArgumentException(msg);
    }

    private NumberUtils() {
    }
}

