/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import org.tiogasolutions.notify.pub.common.TopicInfo;
import org.tiogasolutions.notify.pub.common.TraitInfo;

public class DomainSummary {
    private final List<TopicInfo> topics;
    private final List<TraitInfo> traits;

    @JsonCreator
    public DomainSummary(@JsonProperty(value="topics") List<TopicInfo> topics, @JsonProperty(value="traits") List<TraitInfo> traits) {
        this.topics = topics;
        this.traits = traits;
    }

    public List<TopicInfo> getTopics() {
        return this.topics;
    }

    public List<TraitInfo> getTraits() {
        return this.traits;
    }

    public Optional<TopicInfo> findTopicInfo(String topicName) {
        TopicInfo found = null;
        for (TopicInfo info : this.topics) {
            if (!info.getName().equalsIgnoreCase(topicName)) continue;
            found = info;
        }
        return this.topics.stream().filter(t -> t.getName().equalsIgnoreCase(topicName)).findFirst();
    }

    public Optional<TraitInfo> findTraitInfo(String traitKey) {
        return this.traits.stream().filter(t -> t.getKey().equalsIgnoreCase(traitKey)).findFirst();
    }
}

