/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;
import org.tiogasolutions.couchace.core.api.CouchDatabaseInfo;
import org.tiogasolutions.couchace.core.api.CouchSetup;
import org.tiogasolutions.couchace.core.api.injectable.CouchInjectables;
import org.tiogasolutions.couchace.core.api.injectable.MissingInjectableResponse;
import org.tiogasolutions.couchace.core.api.json.CouchJsonException;
import org.tiogasolutions.couchace.core.api.meta.CouchEmbeddedAttachmentMeta;
import org.tiogasolutions.couchace.core.api.meta.CouchEntityMeta;
import org.tiogasolutions.couchace.core.api.query.CouchJsonKey;
import org.tiogasolutions.couchace.core.api.request.GetRequestFactory;
import org.tiogasolutions.couchace.core.api.request.PostEntityRequest;
import org.tiogasolutions.couchace.core.api.request.PutEntityRequest;
import org.tiogasolutions.couchace.core.api.response.EntityDocument;
import org.tiogasolutions.couchace.core.api.response.GetAttachmentResponse;
import org.tiogasolutions.couchace.core.api.response.TextDocument;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;
import org.tiogasolutions.couchace.core.spi.json.CouchJsonStrategy;
import org.tiogasolutions.couchace.jackson.CouchJacksonMapper;
import org.tiogasolutions.couchace.jackson.internal.CustomJacksonInjectableValues;

public class JacksonCouchJsonStrategy
implements CouchJsonStrategy {
    private static final Logger log = LoggerFactory.getLogger(JacksonCouchJsonStrategy.class);
    private ObjectMapper objectMapper;
    private CouchInjectables couchInjectables;
    private List<Module> moduleList = new ArrayList<Module>();
    private MissingInjectableResponse missingInjectableResponse = MissingInjectableResponse.THROW_EXCEPTION;

    public JacksonCouchJsonStrategy() {
    }

    public JacksonCouchJsonStrategy(Module ... modules) {
        if (modules != null) {
            this.moduleList.addAll(Arrays.asList(modules));
        }
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public CouchInjectables getCouchInjectables() {
        return this.couchInjectables;
    }

    public void setCouchInjectables(CouchInjectables couchInjectables) {
        this.couchInjectables = couchInjectables;
    }

    public MissingInjectableResponse getMissingInjectableResponse() {
        return this.missingInjectableResponse;
    }

    public void setMissingInjectableResponse(MissingInjectableResponse missingInjectableResponse) {
        this.missingInjectableResponse = missingInjectableResponse != null ? missingInjectableResponse : MissingInjectableResponse.THROW_EXCEPTION;
    }

    public void init(CouchSetup couchSetup) {
        CouchJacksonMapper couchJacksonMapper = new CouchJacksonMapper(couchSetup.getMetaRepository(), this.moduleList);
        this.setObjectMapper(couchJacksonMapper);
        if (this.couchInjectables == null) {
            this.setCouchInjectables(couchSetup.getInjectables());
        }
        this.setMissingInjectableResponse(couchSetup.getMissingInjectableResponse());
    }

    public CouchDatabaseInfo readDatabaseInfo(String json) {
        try {
            return (CouchDatabaseInfo)this.objectMapper.readValue(json, CouchDatabaseInfo.class);
        }
        catch (IOException e) {
            throw new CouchJsonException((Throwable)e);
        }
    }

    public String createJsonForPut(PutEntityRequest request) {
        return this.createJsonForWrite(request.getDocumentId(), request.getDocumentRevision(), request.getEntityType(), request.getEntity(), request.getAttachmentInfoMap());
    }

    public String createJsonForPost(PostEntityRequest request) {
        return this.createJsonForWrite(null, null, request.getEntityType(), request.getEntity(), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextDocument readTextDocument(String json) throws CouchJsonException {
        JsonFactory jsonFactory = this.objectMapper.getFactory();
        try (JsonParser parser = jsonFactory.createParser(json);){
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("Expected response JSON to start with an Object: " + parser.getCurrentToken());
            }
            String documentId = null;
            String revision = null;
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String name = parser.getCurrentName();
                parser.nextToken();
                if ("_id".equals(name)) {
                    documentId = parser.getText();
                } else if ("_rev".equals(name)) {
                    revision = parser.getText();
                }
                if (documentId == null || revision == null) continue;
            }
            TextDocument textDocument = new TextDocument(documentId, revision, null, json);
            return textDocument;
        }
        catch (IOException e) {
            throw new CouchJsonException((Throwable)e);
        }
    }

    public List<TextDocument> readTextDocuments(String json) throws CouchJsonException {
        return this.readTextDocumentsUsingTree(json);
    }

    protected List<TextDocument> readTextDocumentsUsingTree(String json) throws CouchJsonException {
        JsonFactory jsonFactory = this.objectMapper.getFactory();
        try {
            ArrayList<TextDocument> documentList;
            try (JsonParser parser = jsonFactory.createParser(json);){
                if (parser.nextToken() != JsonToken.START_OBJECT) {
                    throw new IOException("Expected response JSON to start with an Object: " + parser.getCurrentToken());
                }
                documentList = new ArrayList<TextDocument>();
                while (parser.nextToken() != null) {
                    String name = parser.getCurrentName();
                    if (!"rows".equals(name)) continue;
                    parser.nextToken();
                    ArrayNode rowsNode = (ArrayNode)this.objectMapper.readTree(parser);
                    for (int i = 0; i < rowsNode.size(); ++i) {
                        JsonNode documentNode = rowsNode.get(i);
                        JsonNode idNode = documentNode.get("id");
                        String id = idNode != null ? idNode.asText() : null;
                        JsonNode keyNode = documentNode.get("key");
                        CouchJsonKey jsonKey = keyNode != null ? new CouchJsonKey(new Object[]{keyNode.asText()}) : new CouchJsonKey(new Object[0]);
                        JsonNode contentNode = documentNode.get("doc");
                        if (contentNode == null) {
                            contentNode = documentNode.get("value");
                        }
                        String content = null;
                        String revision = null;
                        if (contentNode != null) {
                            content = contentNode.toString();
                            JsonNode revNode = contentNode.get("_rev");
                            if (revNode == null) {
                                revNode = contentNode.get("rev");
                            }
                            revision = revNode != null ? revNode.asText() : null;
                        }
                        documentList.add(new TextDocument(id, revision, jsonKey, content));
                    }
                }
            }
            return documentList;
        }
        catch (IOException ex) {
            throw new CouchJsonException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> EntityDocument<T> readEntityDocument(GetRequestFactory getRequestFactory, CouchEntityMeta<T> entityMeta, String json) throws CouchJsonException {
        JsonFactory jsonFactory = this.objectMapper.getFactory();
        try (JsonParser parser = jsonFactory.createParser(json);){
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("Expected response JSON to start with an Object: " + parser.getCurrentToken());
            }
            EntityDocument<T> entityDocument = this.finalizeEntityDoc(getRequestFactory, entityMeta, parser, null, json);
            return entityDocument;
        }
        catch (IOException e) {
            throw new CouchJsonException((Throwable)e);
        }
    }

    public <T> List<EntityDocument<T>> readEntityDocuments(GetRequestFactory getRequestFactory, CouchEntityMeta<T> entityMeta, String json) throws CouchJsonException {
        JsonFactory jsonFactory = this.objectMapper.getFactory();
        try {
            ArrayList<EntityDocument<T>> entityDocumentList;
            try (JsonParser parser = jsonFactory.createParser(json);){
                if (parser.nextToken() != JsonToken.START_OBJECT) {
                    throw new IOException("Expected response JSON to start with an Object: " + parser.getCurrentToken());
                }
                entityDocumentList = new ArrayList<EntityDocument<T>>();
                while (parser.nextToken() != null) {
                    String name = parser.getCurrentName();
                    parser.nextToken();
                    if (!"rows".equals(name)) continue;
                    CouchJsonKey key = null;
                    while (parser.hasCurrentToken()) {
                        name = parser.getCurrentName();
                        if ("key".equals(name)) {
                            JsonToken token = parser.getCurrentToken();
                            key = token.isNumeric() ? new CouchJsonKey(new Object[]{parser.getNumberValue()}) : new CouchJsonKey(new Object[]{parser.getText()});
                        } else if ("value".equals(name)) {
                            parser.nextToken();
                            EntityDocument<T> entityDocument = this.finalizeEntityDoc(getRequestFactory, entityMeta, parser, key, json);
                            entityDocumentList.add(entityDocument);
                            key = null;
                        }
                        parser.nextToken();
                    }
                }
            }
            return entityDocumentList;
        }
        catch (IOException ex) {
            throw new CouchJsonException((Throwable)ex);
        }
    }

    protected <T> EntityDocument<T> finalizeEntityDoc(GetRequestFactory getRequestFactory, CouchEntityMeta<T> entityMeta, JsonParser parser, CouchJsonKey key, String json) throws IOException {
        Class entityClass = entityMeta.getEntityClass();
        String id = null;
        String rev = null;
        String entityType = null;
        CouchAttachmentInfoMap attachmentInfoMap = null;
        Object entity = null;
        while (parser.nextToken() != JsonToken.END_OBJECT && parser.getCurrentToken() != null) {
            String name = parser.getCurrentName();
            parser.nextToken();
            if ("_id".equals(name)) {
                id = parser.getText();
                continue;
            }
            if ("_rev".equals(name)) {
                rev = parser.getText();
                continue;
            }
            if ("_attachments".equals(name)) {
                attachmentInfoMap = (CouchAttachmentInfoMap)parser.readValueAs(CouchAttachmentInfoMap.class);
                continue;
            }
            if ("entityType".equals(name)) {
                entityType = parser.getText();
                continue;
            }
            if (!"entity".equals(name) || entityClass == String.class) continue;
            if (id == null) {
                throw CouchJsonException.internalServerError((String)"Error finalizing Entity from JSON, found entity but _id was never found.");
            }
            if (rev == null) {
                throw CouchJsonException.internalServerError((String)"Error finalizing Entity from JSON, found entity but _rev was never found.");
            }
            CustomJacksonInjectableValues inject = this.buildInjectableValues(getRequestFactory, entityMeta, id, rev);
            entity = this.objectMapper.reader(entityClass).with((InjectableValues)inject).readValue(parser);
        }
        if (entity != null) {
            if (entityMeta.hasId() && !entityMeta.isIdSet(entity)) {
                entityMeta.writeDocumentId(entity, id);
            }
            if (entityMeta.hasRevision() && !entityMeta.isRevisionSet(entity)) {
                entityMeta.writeDocumentRevision(entity, rev);
            }
            if (entityMeta.hasAttachmentsMeta()) {
                entityMeta.writeAttachmentInfoMap(entity, attachmentInfoMap);
            }
        }
        if (entity == null && entityClass == String.class) {
            entity = entityClass.cast(json);
        }
        return new EntityDocument(id, rev, key, entityType, entity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String createJsonForWrite(String documentId, String revision, String entityType, Object entity, CouchAttachmentInfoMap attachmentInfoMap) {
        ArgUtil.assertNotEmpty((String)entityType, (String)"entityType");
        ArgUtil.assertNotNull((Object)entity, (String)"entity");
        JsonFactory jsonFactory = this.objectMapper.getFactory();
        try {
            StringWriter writer = new StringWriter();
            try (JsonGenerator generator = jsonFactory.createGenerator((Writer)writer);){
                generator.writeStartObject();
                if (documentId != null) {
                    generator.writeStringField("_id", documentId);
                }
                if (revision != null) {
                    generator.writeStringField("_rev", revision);
                }
                generator.writeStringField("entityType", entityType);
                generator.writeObjectField("entity", entity);
                if (attachmentInfoMap != null) {
                    generator.writeObjectField("_attachments", (Object)attachmentInfoMap);
                }
                generator.writeEndObject();
                generator.flush();
                String json = writer.toString();
                if (log.isDebugEnabled()) {
                    log.debug("Put JSON: " + json);
                }
                String string = json;
                return string;
            }
        }
        catch (IOException e) {
            throw new CouchJsonException((Throwable)e);
        }
    }

    protected CustomJacksonInjectableValues buildInjectableValues(GetRequestFactory getRequestFactory, CouchEntityMeta<?> entityMeta, String documentId, String revision) {
        CustomJacksonInjectableValues inject = new CustomJacksonInjectableValues(this.missingInjectableResponse, this.couchInjectables);
        if (entityMeta.hasId() && documentId != null) {
            inject.addValue(entityMeta.getIdName(), documentId);
        }
        if (entityMeta.hasRevision() && revision != null) {
            inject.addValue(entityMeta.getRevisionName(), revision);
        }
        if (entityMeta.hasEmbeddedAttachments()) {
            for (CouchEmbeddedAttachmentMeta attachmentDef : entityMeta.getEmbeddedAttachmentMetaList()) {
                GetAttachmentResponse response = getRequestFactory.attachment(documentId, revision, attachmentDef.getAttachmentName()).execute();
                inject.addValue(attachmentDef.getAttachmentName(), response.getContent());
            }
        }
        return inject;
    }
}

