/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.domain.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.tiogasolutions.dev.domain.query.QueryResult;

public final class ListQueryResult<T>
implements QueryResult<T> {
    private final Class<? extends T> containsType;
    private final int limit;
    private final int offset;
    private int totalFound;
    private boolean totalExact;
    private final List<T> results;

    public static <T> ListQueryResult<T> newEmpty(Class<T> type) {
        return new ListQueryResult<T>(type, 0, 0, 0, true, Collections.emptyList());
    }

    public static <T> ListQueryResult<T> newSingle(Class<T> type, T result) {
        if (result == null) {
            throw new NullPointerException("Null value argument given to newSingle");
        }
        return new ListQueryResult<T>(type, 0, 0, 1, true, Collections.singleton(result));
    }

    public static <T> ListQueryResult<T> newComplete(Class<T> type, Collection<T> results) {
        return new ListQueryResult<T>(type, 0, 0, results.size(), true, results);
    }

    public static <T> ListQueryResult<T> newComplete(Class<T> type, T[] results) {
        return new ListQueryResult<T>(type, 0, 0, results.length, true, Arrays.asList(results));
    }

    public static <T> ListQueryResult<T> newResult(Class<? extends T> type, int limit, int offset, int totalFound, boolean totalExact, Collection<T> results) {
        return new ListQueryResult<T>(type, limit, offset, totalFound, totalExact, results);
    }

    public static <T> ListQueryResult<T> newResult(Class<T> type, int limit, int offset, int totalFound, boolean totalExact, T[] results) {
        return new ListQueryResult<T>(type, limit, offset, totalFound, totalExact, Arrays.asList(results));
    }

    private ListQueryResult(Class<? extends T> containsType, int limit, int offset, int totalFound, boolean totalExact, Collection<T> results) {
        this.containsType = containsType;
        this.limit = limit;
        this.offset = offset;
        this.totalFound = totalFound;
        this.totalExact = totalExact;
        ArrayList<T> localList = new ArrayList<T>(results);
        this.results = Collections.unmodifiableList(localList);
    }

    @Override
    public Class<? extends T> getContainsType() {
        return this.containsType;
    }

    @Override
    public boolean isContainsType(Class<?> containsType) {
        return this.containsType.isAssignableFrom(containsType);
    }

    @Override
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return !this.results.isEmpty();
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getSize() {
        return this.results.size();
    }

    @Override
    public int getTotalFound() {
        return this.totalFound;
    }

    @Override
    public boolean isTotalExact() {
        return this.totalExact;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public T getFirst() {
        return this.results.get(0);
    }

    @Override
    public T getLast() {
        return this.results.get(this.results.size() - 1);
    }

    @Override
    public T getAt(int index) {
        return this.results.get(index);
    }

    @Override
    public List<T> getResults() {
        return this.results;
    }

    @Override
    public Iterator<T> iterator() {
        return this.results.iterator();
    }

    @Override
    public boolean getHasPrevious() {
        return this.offset != 0;
    }

    @Override
    public boolean getHasNext() {
        return this.offset + this.results.size() < this.totalFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListQueryResult that = (ListQueryResult)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (this.totalFound != that.totalFound) {
            return false;
        }
        if (this.results.size() != that.results.size()) {
            return false;
        }
        if (!this.results.equals(that.results)) {
            return false;
        }
        return this.containsType.equals(that.containsType);
    }

    public int hashCode() {
        int result = this.containsType.hashCode();
        result = 31 * result + this.offset;
        result = 31 * result + this.limit;
        result = 31 * result + this.totalFound;
        result = 31 * result + this.results.hashCode();
        return result;
    }

    public String toString() {
        return "ListQueryResult{type=" + this.containsType + ", limit=" + this.limit + ", offset=" + this.offset + ", totalFound=" + this.totalFound + ", results=" + this.results + '}';
    }
}

