/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.runners.grizzly;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;

public abstract class ShutdownUtils {
    public static void shutdownRemote(GrizzlyServerConfig config) throws IOException {
        ShutdownUtils.sendShutdown(config);
        ShutdownUtils.waitForShutdown(config);
    }

    public static void sendShutdown(GrizzlyServerConfig config) throws IOException {
        try (Socket localSocket = new Socket(config.getHostName(), config.getShutdownPort());
             OutputStream outStream = localSocket.getOutputStream();){
            outStream.write("SHUTDOWN".getBytes());
            outStream.flush();
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    public static void waitForShutdown(GrizzlyServerConfig config) throws IOException {
        long start = System.currentTimeMillis();
        do {
            if (ShutdownUtils.isConnected(config)) continue;
            return;
        } while (System.currentTimeMillis() - start < config.getShutdownTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConnected(GrizzlyServerConfig config) throws IOException {
        try (Socket socket = null;){
            socket = new Socket(config.getHostName(), config.getShutdownPort());
            boolean bl = true;
            return bl;
        }
    }
}

