/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.slack;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.StringUtils;

public class SlackMessage {
    private static Logger log = LoggerFactory.getLogger(SlackMessage.class);
    private String userName;
    private String channel;
    private String text;
    private String iconUrl;
    private String iconEmoji;

    private static String field(String fieldName, String value) {
        return String.format("\"%s\":\"%s\",", fieldName, value);
    }

    public String toJson() {
        int lastIndex;
        StringBuilder sb = new StringBuilder("{");
        if (StringUtils.isNotBlank((Object)this.userName)) {
            sb.append(SlackMessage.field("username", this.userName));
        }
        if (StringUtils.isNotBlank((Object)this.channel)) {
            sb.append(SlackMessage.field("channel", this.channel));
        }
        if (StringUtils.isNotBlank((Object)this.text)) {
            if (this.text.endsWith("\n")) {
                this.text = this.text.substring(0, this.text.length() - 1);
            }
            sb.append(SlackMessage.field("text", this.text));
        }
        if (StringUtils.isNotBlank((Object)this.iconUrl)) {
            sb.append(SlackMessage.field("icon_url", this.iconUrl));
        }
        if (StringUtils.isNotBlank((Object)this.iconEmoji)) {
            sb.append(SlackMessage.field("icon_emoji", this.iconEmoji));
        }
        if (sb.charAt(lastIndex = sb.length() - 1) == ',') {
            sb.deleteCharAt(lastIndex);
        }
        sb.append("}");
        String json = sb.toString();
        if (log.isTraceEnabled()) {
            log.trace("Message json [" + json + "]");
        }
        return json;
    }

    public String getUserName() {
        return this.userName;
    }

    public SlackMessage setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getChannel() {
        return this.channel;
    }

    public SlackMessage setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public SlackMessage setText(String text) {
        this.text = text;
        return this;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public SlackMessage setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public String getIconEmoji() {
        return this.iconEmoji;
    }

    public SlackMessage setIconEmoji(String iconEmoji) {
        this.iconEmoji = iconEmoji;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackMessage message = (SlackMessage)o;
        if (this.channel != null ? !this.channel.equals(message.channel) : message.channel != null) {
            return false;
        }
        if (this.iconEmoji != null ? !this.iconEmoji.equals(message.iconEmoji) : message.iconEmoji != null) {
            return false;
        }
        if (this.iconUrl != null ? !this.iconUrl.equals(message.iconUrl) : message.iconUrl != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(message.text) : message.text != null) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(message.userName) : message.userName != null);
    }

    public int hashCode() {
        int result = this.userName != null ? this.userName.hashCode() : 0;
        result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.iconUrl != null ? this.iconUrl.hashCode() : 0);
        result = 31 * result + (this.iconEmoji != null ? this.iconEmoji.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SlackMessage{userName='" + this.userName + '\'' + ", channel='" + this.channel + '\'' + ", text='" + this.text + '\'' + ", iconUrl='" + this.iconUrl + '\'' + ", iconEmoji='" + this.iconEmoji + '\'' + '}';
    }
}

