/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchDatabaseInfo;
import org.tiogasolutions.couchace.core.api.CouchException;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.meta.CouchMetaRepository;
import org.tiogasolutions.couchace.core.api.request.CouchFeature;
import org.tiogasolutions.couchace.core.api.request.CouchFeatureSet;
import org.tiogasolutions.couchace.core.api.request.DeleteRequestFactory;
import org.tiogasolutions.couchace.core.api.request.GetRequestFactory;
import org.tiogasolutions.couchace.core.api.request.HeadRequestFactory;
import org.tiogasolutions.couchace.core.api.request.PostRequestFactory;
import org.tiogasolutions.couchace.core.api.request.PutRequestFactory;
import org.tiogasolutions.couchace.core.api.response.WriteResponse;
import org.tiogasolutions.couchace.core.internal.RequestExecutor;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpClient;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpResponse;
import org.tiogasolutions.couchace.core.spi.http.HttpGetRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpHeadRequest;
import org.tiogasolutions.couchace.core.spi.json.CouchJsonStrategy;

public class CouchDatabaseImpl
implements CouchDatabase {
    private static final Logger log = LoggerFactory.getLogger(CouchDatabaseImpl.class);
    private final String databaseName;
    private final CouchJsonStrategy jsonStrategy;
    private final CouchHttpClient httpClient;
    private final CouchFeatureSet featureSet;
    private final GetRequestFactory getRequestFactory;
    private final PutRequestFactory putRequestFactory;
    private final PostRequestFactory postRequestFactory;
    private final HeadRequestFactory headRequestFactory;
    private final DeleteRequestFactory deleteRequestFactory;
    private final CouchMetaRepository metaRepository;

    public CouchDatabaseImpl(String databaseName, CouchHttpClient httpClient, CouchJsonStrategy jsonStrategy, CouchMetaRepository metaRepository, CouchFeatureSet featureSet) {
        ArgUtil.assertNotNull(databaseName, "databaseName");
        ArgUtil.assertNotNull(httpClient, "httpClient");
        ArgUtil.assertNotNull(jsonStrategy, "jsonStrategy");
        this.databaseName = databaseName;
        this.httpClient = httpClient;
        this.jsonStrategy = jsonStrategy;
        this.metaRepository = metaRepository;
        this.featureSet = featureSet;
        RequestExecutor requestExecutor = new RequestExecutor(this);
        this.getRequestFactory = new GetRequestFactory(requestExecutor);
        this.putRequestFactory = new PutRequestFactory(requestExecutor);
        this.postRequestFactory = new PostRequestFactory(requestExecutor);
        this.headRequestFactory = new HeadRequestFactory(requestExecutor);
        this.deleteRequestFactory = new DeleteRequestFactory(requestExecutor);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public boolean exists() {
        HttpHeadRequest httpHeadRequest = new HttpHeadRequest(this.databaseName, null, null);
        CouchHttpResponse couchHttpResponse = this.httpClient.head(httpHeadRequest);
        return couchHttpResponse.isOk();
    }

    @Override
    public CouchDatabaseInfo databaseInfo() {
        HttpGetRequest httpGetRequest = new HttpGetRequest(this.databaseName, null, null, CouchMediaType.APPLICATION_JSON);
        CouchHttpResponse couchHttpResponse = this.httpClient.get(httpGetRequest);
        if (couchHttpResponse.isOk()) {
            return this.jsonStrategy.readDatabaseInfo(couchHttpResponse.getStringContent());
        }
        if (couchHttpResponse.isNotFound()) {
            throw CouchException.notFound("Database " + this.databaseName + " does not exist");
        }
        throw new CouchException(couchHttpResponse.getHttpStatus(), "Error reading database info for database " + this.databaseName);
    }

    @Override
    public WriteResponse createDatabase() {
        CouchHttpResponse httpResponse = this.httpClient.createDatabase(this.databaseName);
        return new WriteResponse(httpResponse);
    }

    @Override
    public WriteResponse deleteDatabase() {
        if (this.featureSet.isTrue(CouchFeature.ALLOW_DB_DELETE)) {
            CouchHttpResponse httpResponse = this.httpClient.deleteDatabase(this.databaseName);
            return new WriteResponse(httpResponse);
        }
        throw CouchException.forbidden("Deletion of database " + this.databaseName + " is not allowed. To allow configure with CouchFeature.ALLOW_DB_DELETE.");
    }

    @Override
    public WriteResponse recreateDatabase() {
        if (this.exists()) {
            this.deleteDatabase();
        }
        return this.createDatabase();
    }

    @Override
    public HeadRequestFactory head() {
        return this.headRequestFactory;
    }

    @Override
    public GetRequestFactory get() {
        return this.getRequestFactory;
    }

    @Override
    public PutRequestFactory put() {
        return this.putRequestFactory;
    }

    @Override
    public PostRequestFactory post() {
        return this.postRequestFactory;
    }

    @Override
    public DeleteRequestFactory delete() {
        return this.deleteRequestFactory;
    }

    @Override
    public CouchFeatureSet getFeatureSet() {
        return this.featureSet;
    }

    @Override
    public CouchJsonStrategy getJsonStrategy() {
        return this.jsonStrategy;
    }

    @Override
    public CouchHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public CouchMetaRepository getMetaRepository() {
        return this.metaRepository;
    }
}

