/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.server.grizzly;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;
import org.tiogasolutions.notify.NotifyObjectMapper;
import org.tiogasolutions.notify.engine.web.readers.BundledStaticContentReader;
import org.tiogasolutions.notify.kernel.config.CouchEnvironment;
import org.tiogasolutions.notify.kernel.config.CouchServersConfig;
import org.tiogasolutions.notify.kernel.config.SystemConfiguration;
import org.tiogasolutions.notify.kernel.config.TrustedUserStore;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.task.TaskProcessorExecutor;
import org.tiogasolutions.notify.processor.logger.LoggerTaskProcessor;
import org.tiogasolutions.notify.processor.push.LivePushClientFactory;
import org.tiogasolutions.notify.processor.push.PushTaskProcessor;
import org.tiogasolutions.notify.processor.slack.SlackTaskProcessor;
import org.tiogasolutions.notify.processor.smtp.SmtpTaskProcessor;
import org.tiogasolutions.notify.processor.swing.SwingTaskProcessor;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;

@Profile(value={"hosted"})
@Configuration
public class NotifyHostedSpringConfig {
    private String getContext() {
        return EnvUtils.findProperty((String)"notify.context", (String)"");
    }

    private int getPort() {
        String value = EnvUtils.findProperty((String)"notify.port", (String)"8080");
        return Integer.valueOf(value);
    }

    private int getShutdownPort() {
        String value = EnvUtils.findProperty((String)"notify.shutdownPort", (String)"8081");
        return Integer.valueOf(value);
    }

    private String getHostName() {
        return EnvUtils.findProperty((String)"notify.hostName", (String)"localhost");
    }

    private String getMasterUrl() {
        return EnvUtils.requireProperty((String)"notify.masterUrl");
    }

    private String getMasterUsername() {
        return EnvUtils.requireProperty((String)"notify.masterUsername");
    }

    private String getMasterPassword() {
        return EnvUtils.requireProperty((String)"notify.masterPassword");
    }

    private String getMasterDatabaseName() {
        return EnvUtils.requireProperty((String)"notify.masterDatabaseName");
    }

    private String getNotificationUrl() {
        return EnvUtils.requireProperty((String)"notify.notificationUrl");
    }

    private String getNotificationUsername() {
        return EnvUtils.requireProperty((String)"notify.notificationUsername");
    }

    private String getNotificationPassword() {
        return EnvUtils.requireProperty((String)"notify.notificationPassword");
    }

    private String getNotificationDatabasePrefix() {
        return EnvUtils.requireProperty((String)"notify.notificationDatabasePrefix");
    }

    private String getNotificationDatabaseSuffix() {
        return EnvUtils.requireProperty((String)"notify.notificationDatabaseSuffix");
    }

    private String getRequestUrl() {
        return EnvUtils.requireProperty((String)"notify.requestUrl");
    }

    private String getRequestUsername() {
        return EnvUtils.requireProperty((String)"notify.requestUsername");
    }

    private String getRequestPassword() {
        return EnvUtils.requireProperty((String)"notify.requestPassword");
    }

    private String getRequestDatabasePrefix() {
        return EnvUtils.requireProperty((String)"notify.requestDatabasePrefix");
    }

    private String getRequestDatabaseSuffix() {
        return EnvUtils.requireProperty((String)"notify.requestDatabaseSuffix");
    }

    @Bean
    public LivePushClientFactory livePushClientFactory() {
        return new LivePushClientFactory();
    }

    @Bean
    public NotifyObjectMapper notifyObjectMapper() {
        return new NotifyObjectMapper();
    }

    @Bean
    public TiogaJacksonTranslator tiogaJacksonTranslator(NotifyObjectMapper objectMapper) {
        return new TiogaJacksonTranslator((ObjectMapper)objectMapper);
    }

    @Bean
    public TaskProcessorExecutor taskProcessorExecutor(DomainKernel domainKernel, EventBus eventBus, SwingTaskProcessor swingTaskProcessor, LoggerTaskProcessor loggerTaskProcessor, PushTaskProcessor pushTaskProcessor, SlackTaskProcessor slackTaskProcessor, SmtpTaskProcessor smtpTaskProcessor) {
        return new TaskProcessorExecutor(domainKernel, eventBus, Arrays.asList(swingTaskProcessor, loggerTaskProcessor, pushTaskProcessor, slackTaskProcessor, smtpTaskProcessor));
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.SystemConfiguration"})
    public SystemConfiguration systemConfiguration() {
        return new SystemConfiguration("*", "/api/v1/client", "/api/v1/admin");
    }

    @Bean(name={"org.tiogasolutions.notify.engine.web.readers.ExternalizedStaticContentReader"})
    BundledStaticContentReader bundledStaticContentReader() {
        return new BundledStaticContentReader("/org/tiogasolutions/notify/admin/app");
    }

    @Bean(name={"org.tiogasolutions.runners.grizzly.GrizzlyServerConfig"})
    public GrizzlyServerConfig grizzlyServerConfig() {
        GrizzlyServerConfig config = new GrizzlyServerConfig();
        config.setHostName(this.getHostName());
        config.setPort(this.getPort());
        config.setShutdownPort(this.getShutdownPort());
        config.setContext(this.getContext());
        config.setToOpenBrowser(false);
        return config;
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.CouchServersConfig"})
    public CouchServersConfig couchServersConfig() {
        CouchServersConfig config = new CouchServersConfig();
        config.setMasterUrl(this.getMasterUrl());
        config.setMasterUsername(this.getMasterUsername());
        config.setMasterPassword(this.getMasterPassword());
        config.setMasterDatabaseName(this.getMasterDatabaseName());
        config.setNotificationUrl(this.getNotificationUrl());
        config.setNotificationUsername(this.getNotificationUsername());
        config.setNotificationPassword(this.getNotificationPassword());
        config.setNotificationDatabasePrefix(this.getNotificationDatabasePrefix());
        config.setNotificationDatabaseSuffix(this.getNotificationDatabaseSuffix());
        config.setRequestUrl(this.getRequestUrl());
        config.setRequestUsername(this.getRequestUsername());
        config.setRequestPassword(this.getRequestPassword());
        config.setRequestDatabasePrefix(this.getRequestDatabasePrefix());
        config.setRequestDatabaseSuffix(this.getRequestDatabaseSuffix());
        return config;
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.TrustedUserStore"})
    public TrustedUserStore trustedUserStore() {
        return new TrustedUserStore("admin:password");
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.CouchEnvironment"})
    public CouchEnvironment couchEnvironment() {
        return new CouchEnvironment().setTesting(true);
    }
}

