/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.query;

import org.tiogasolutions.couchace.core.api.query.CouchPageQuery;

public class CouchPageNavigation {
    private final int pageSize;
    private final String requestedPage;
    private final String previousPage;
    private final String nextPage;
    private final boolean includeDocs;

    public static CouchPageNavigation empty() {
        return new CouchPageNavigation(0, null, null, null, false);
    }

    public CouchPageNavigation(int pageSize, String requestedPage, String previousPage, String nextPage, boolean includeDocs) {
        this.pageSize = pageSize;
        this.requestedPage = requestedPage;
        this.previousPage = previousPage;
        this.nextPage = nextPage;
        this.includeDocs = includeDocs;
    }

    public CouchPageQuery queryNextPage() {
        return new CouchPageQuery(this.pageSize, this.nextPage, this.requestedPage, this.includeDocs);
    }

    public CouchPageQuery queryPreviousPage() {
        return new CouchPageQuery(this.pageSize, this.previousPage, this.requestedPage, this.includeDocs);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getRequestedPage() {
        return this.requestedPage;
    }

    public boolean hasRequestedPage() {
        return this.requestedPage != null;
    }

    public String getPreviousPage() {
        return this.previousPage;
    }

    public String getNextPage() {
        return this.nextPage;
    }

    public boolean hasNextPage() {
        return this.nextPage != null;
    }

    public boolean hasPreviousPage() {
        return this.previousPage != null;
    }

    public boolean isIncludeDocs() {
        return this.includeDocs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CouchPageNavigation that = (CouchPageNavigation)o;
        if (this.pageSize != that.pageSize) {
            return false;
        }
        if (this.nextPage != null ? !this.nextPage.equals(that.nextPage) : that.nextPage != null) {
            return false;
        }
        if (this.previousPage != null ? !this.previousPage.equals(that.previousPage) : that.previousPage != null) {
            return false;
        }
        return !(this.requestedPage != null ? !this.requestedPage.equals(that.requestedPage) : that.requestedPage != null);
    }

    public int hashCode() {
        int result = this.pageSize;
        result = 31 * result + (this.requestedPage != null ? this.requestedPage.hashCode() : 0);
        result = 31 * result + (this.previousPage != null ? this.previousPage.hashCode() : 0);
        result = 31 * result + (this.nextPage != null ? this.nextPage.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PageNavigation{pageSize=" + this.pageSize + ", requestedPage='" + this.requestedPage + '\'' + ", previousPage='" + this.previousPage + '\'' + ", nextPage='" + this.nextPage + '\'' + '}';
    }
}

