/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.spi.http;

import java.net.URI;
import java.util.Arrays;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.http.CouchMethodType;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpResponseBuilder;

public class CouchHttpResponse {
    private final URI uri;
    private final CouchHttpStatus httpStatus;
    private final CouchMethodType methodType;
    private final String documentId;
    private final String etag;
    private final CouchMediaType contentType;
    private final Object content;

    public static CouchHttpResponseBuilder builder(CouchMethodType methodType, URI uri, CouchHttpStatus statusCode) {
        return new CouchHttpResponseBuilder(methodType, uri, statusCode);
    }

    public CouchHttpResponse(CouchMethodType methodType, URI uri, CouchHttpStatus httpStatus, String documentId, String etag, CouchMediaType contentType, Object content) {
        ArgUtil.assertNotNull((Object)methodType, "HttpMethodType");
        ArgUtil.assertNotNull(uri, "URI");
        ArgUtil.assertNotNull((Object)httpStatus, "HttpStatusCode");
        this.uri = uri;
        this.methodType = methodType;
        this.httpStatus = httpStatus;
        this.documentId = documentId;
        this.etag = etag;
        this.contentType = contentType;
        this.content = content;
    }

    public CouchMethodType getMethodType() {
        return this.methodType;
    }

    public URI getUri() {
        return this.uri;
    }

    public CouchHttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public int getHttpStatusCode() {
        return this.httpStatus.getCode();
    }

    public boolean isOk() {
        return this.httpStatus.isOk();
    }

    public boolean isNotFound() {
        return this.httpStatus.isNotFound();
    }

    public boolean isCreated() {
        return this.httpStatus.isCreated();
    }

    public boolean isConflict() {
        return this.httpStatus.isConflict();
    }

    public boolean isSuccess() {
        return this.httpStatus == CouchHttpStatus.CREATED || this.httpStatus == CouchHttpStatus.OK;
    }

    public boolean isError() {
        return this.httpStatus != CouchHttpStatus.CREATED && this.httpStatus != CouchHttpStatus.OK;
    }

    public CouchMediaType getContentType() {
        return this.contentType;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getEtag() {
        return this.etag;
    }

    public boolean hasEtag() {
        return this.etag != null;
    }

    public Object getContent() {
        return this.content;
    }

    public String getStringContent() {
        String stringContent;
        if (this.content == null) {
            stringContent = null;
        } else if (this.content instanceof byte[]) {
            byte[] bytes = (byte[])this.content;
            stringContent = new String(bytes);
        } else if (this.content.getClass().isArray()) {
            Object[] array = (Object[])this.content;
            stringContent = Arrays.asList(new Object[]{array}).toString();
        } else {
            stringContent = this.content.toString();
        }
        return stringContent;
    }

    public Long getLongContent() {
        return this.content != null ? Long.valueOf(this.content.toString()) : null;
    }

    public CouchErrorContent getErrorContent() {
        return CouchErrorContent.parseJson(this.getStringContent());
    }

    public String getErrorReason() {
        return this.getErrorContent().getReason();
    }

    public boolean isEmpty() {
        if (this.content == null) {
            return true;
        }
        if (this.content instanceof String) {
            return ((String)this.content).isEmpty();
        }
        return false;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

