/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.route;

import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;

public class ArgValue {
    private final ArgType argType;
    private final Object value;

    public ArgValue(Object value) {
        this.value = value;
        if (value == null) {
            this.argType = ArgType.STRING;
        } else if (value instanceof String) {
            this.argType = ArgType.STRING;
        } else if (value instanceof Number) {
            this.argType = ArgType.NUMBER;
        } else if (value instanceof Boolean) {
            this.argType = ArgType.BOOLEAN;
        } else if (value instanceof List) {
            this.argType = ArgType.LIST;
        } else if (value instanceof Map) {
            this.argType = ArgType.MAP;
        } else {
            throw ApiException.badRequest((String)("Unsupported ArgType " + value.getClass()), (String[])new String[0]);
        }
    }

    public ArgType getArgType() {
        return this.argType;
    }

    public boolean isEqual(Object other) {
        if (this.value == null) {
            return other == null;
        }
        return this.value.equals(other);
    }

    @JsonValue
    public Object getValue() {
        return this.value;
    }

    public Object asObject() {
        return this.value;
    }

    public String asString() {
        return this.value != null ? this.value.toString() : null;
    }

    public Boolean asBoolean() {
        return (Boolean)this.value;
    }

    public Number asNumber() {
        return (Number)this.value;
    }

    public <T> T asEnum(Class<T> type) {
        try {
            if (this.value == null) {
                return null;
            }
            Method method = ReflectUtils.getMethod(type, (String)"valueOf", (Class[])new Class[]{String.class});
            return (T)method.invoke(null, this.value.toString());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            String msg = String.format("The static method valueOf(String) could not be invoked for %s.", type.getName());
            throw new UnsupportedOperationException(msg, e);
        }
    }

    public List<ArgValue> asList() {
        List valueList = (List)this.value;
        return valueList.stream().map(ArgValue::new).collect(Collectors.toList());
    }

    public Map<String, ArgValue> asMap() {
        Map valueMap = (Map)this.value;
        HashMap<String, ArgValue> argValueMap = new HashMap<String, ArgValue>();
        for (Map.Entry entry : valueMap.entrySet()) {
            argValueMap.put((String)entry.getKey(), new ArgValue(entry.getValue()));
        }
        return argValueMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgValue argValue = (ArgValue)o;
        if (this.argType != argValue.argType) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(argValue.value) : argValue.value != null);
    }

    public int hashCode() {
        int result = this.argType != null ? this.argType.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ArgValue{argType=" + (Object)((Object)this.argType) + ", value=" + this.value + '}';
    }

    public static enum ArgType {
        STRING,
        NUMBER,
        BOOLEAN,
        LIST,
        MAP;

    }
}

