/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.jackson.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfo;
import org.tiogasolutions.couchace.core.api.json.CouchJsonException;

public final class CouchAttachmentMetaDeserializer
extends StdDeserializer<CouchAttachmentInfo> {
    public CouchAttachmentMetaDeserializer() {
        super(CouchAttachmentInfo.class);
    }

    public CouchAttachmentInfo deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String contentType = null;
        Integer revPos = null;
        String digest = null;
        Long length = null;
        Boolean stub = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String name = parser.getCurrentName();
            parser.nextToken();
            if ("content_type".equalsIgnoreCase(name)) {
                contentType = parser.getValueAsString();
                continue;
            }
            if ("revpos".equalsIgnoreCase(name)) {
                revPos = parser.getIntValue();
                continue;
            }
            if ("digest".equalsIgnoreCase(name)) {
                digest = parser.getValueAsString();
                continue;
            }
            if ("length".equalsIgnoreCase(name)) {
                length = parser.getLongValue();
                continue;
            }
            if (!"stub".equalsIgnoreCase(name)) continue;
            stub = parser.getBooleanValue();
        }
        if (contentType == null) {
            throw new CouchJsonException("CouchAttachmentMeta JSON does not specify containsType");
        }
        if (revPos == null) {
            throw new CouchJsonException("CouchAttachmentMeta JSON does not specify revPos");
        }
        if (digest == null) {
            throw new CouchJsonException("CouchAttachmentMeta JSON does not specify digest");
        }
        if (length == null) {
            throw new CouchJsonException("CouchAttachmentMeta JSON does not specify length");
        }
        if (stub == null) {
            throw new CouchJsonException("CouchAttachmentMeta JSON does not specify stub");
        }
        return new CouchAttachmentInfo(contentType, revPos.intValue(), digest, length.longValue(), stub.booleanValue());
    }
}

