/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.privilegedactions;

import java.security.PrivilegedAction;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class NewInstance<T>
implements PrivilegedAction<T> {
    private static final Log log = LoggerFactory.make();
    private final Class<T> clazz;
    private final String message;

    public static <T> NewInstance<T> action(Class<T> clazz, String message) {
        return new NewInstance<T>(clazz, message);
    }

    private NewInstance(Class<T> clazz, String message) {
        this.clazz = clazz;
        this.message = message;
    }

    @Override
    public T run() {
        try {
            return this.clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw log.getUnableToInstantiateException(this.message, this.clazz, e);
        }
        catch (IllegalAccessException e) {
            throw log.getUnableToInstantiateException(this.clazz, (Exception)e);
        }
        catch (RuntimeException e) {
            throw log.getUnableToInstantiateException(this.clazz, (Exception)e);
        }
    }
}

