/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;

public final class ValidationResultUtil {
    private static final String VALIDATION_RESULT = "javax.mvc.validation.ValidationResult";

    private ValidationResultUtil() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static Field getValidationResultField(Object resource) {
        Class<?> clazz = resource.getClass();
        do {
            for (Field f : clazz.getDeclaredFields()) {
                if (!f.getType().getName().equals(VALIDATION_RESULT) || f.getAnnotation(Inject.class) == null) continue;
                return f;
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return null;
    }

    public static void updateValidationResultField(Object resource, Field field, Set<ConstraintViolation<?>> constraints) {
        try {
            Method setter;
            field.setAccessible(true);
            Object obj = field.get(resource);
            try {
                setter = obj.getClass().getMethod("setViolations", Set.class);
            }
            catch (NoSuchMethodException e) {
                setter = obj.getClass().getSuperclass().getMethod("setViolations", Set.class);
            }
            setter.invoke(obj, constraints);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static void updateValidationResultProperty(Object resource, Method getter, Set<ConstraintViolation<?>> constraints) {
        try {
            Method setViolations;
            Object obj = getter.invoke(resource, new Object[0]);
            try {
                setViolations = obj.getClass().getMethod("setViolations", Set.class);
            }
            catch (NoSuchMethodException e) {
                setViolations = obj.getClass().getSuperclass().getMethod("setViolations", Set.class);
            }
            setViolations.invoke(obj, constraints);
            Method setter = ValidationResultUtil.getValidationResultSetter(resource);
            if (setter != null) {
                setter.invoke(resource, obj);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static boolean hasValidationResultProperty(Object resource) {
        return ValidationResultUtil.getValidationResultGetter(resource) != null && ValidationResultUtil.getValidationResultSetter(resource) != null;
    }

    public static Method getValidationResultGetter(Object resource) {
        Class<?> clazz = resource.getClass();
        do {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!ValidationResultUtil.isValidationResultGetter(m)) continue;
                return m;
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return null;
    }

    private static boolean isValidationResultGetter(Method m) {
        return m.getName().startsWith("get") && m.getReturnType().getName().equals(VALIDATION_RESULT) && Modifier.isPublic(m.getModifiers()) && m.getParameterTypes().length == 0;
    }

    public static Method getValidationResultSetter(Object resource) {
        Class<?> clazz = resource.getClass();
        do {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!ValidationResultUtil.isValidationResultSetter(m)) continue;
                return m;
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return null;
    }

    private static boolean isValidationResultSetter(Method m) {
        return m.getName().startsWith("set") && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].getName().equals(VALIDATION_RESULT) && m.getReturnType() == Void.TYPE && Modifier.isPublic(m.getModifiers()) && m.getAnnotation(Inject.class) != null;
    }
}

