/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.server.grizzly;

import ch.qos.logback.classic.Level;
import java.nio.file.Path;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.tiogasolutions.app.common.AppPathResolver;
import org.tiogasolutions.app.common.AppUtils;
import org.tiogasolutions.lib.spring.SpringUtils;
import org.tiogasolutions.runners.grizzly.GrizzlyServer;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.runners.grizzly.ShutdownUtils;

public class NotifyServer {
    private static final Logger log = LoggerFactory.getLogger(NotifyServer.class);

    public static void main(String ... args) throws Exception {
        AppUtils.initLogback((Level)Level.WARN);
        AppUtils.setLogLevel((Level)Level.INFO, (Class[])new Class[]{NotifyServer.class});
        AppUtils.setLogLevel((Level)Level.INFO, (Class[])new Class[]{GrizzlyServer.class});
        AppPathResolver resolver = new AppPathResolver("notify.");
        Path runtimeDir = resolver.resolveRuntimePath();
        Path configDir = resolver.resolveConfigDir(runtimeDir);
        Path logbackFile = AppUtils.initLogback((Path)configDir, (String)"notify.log.config", (String)"logback.xml");
        String springConfigPath = resolver.resolveSpringPath(configDir, "classpath:/tioga-notify-server-grizzly/spring-config.xml");
        String[] activeProfiles = resolver.resolveSpringProfiles();
        boolean shuttingDown = Arrays.asList(args).contains("-shutdown");
        String action = shuttingDown ? "Shutting down" : "Starting";
        log.info("{} server:\n  *  Runtime Dir     (notify.runtime.dir)     {}\n  *  Config Dir      (notify.config.dir)      {}\n  *  Logback File    (notify.log.config)      {}\n  *  Spring Path     (notify.spring.config)   {}\n  *  Active Profiles (notify.active.profiles) {}", new Object[]{action, runtimeDir, configDir, logbackFile, springConfigPath, Arrays.asList(activeProfiles)});
        AbstractXmlApplicationContext applicationContext = SpringUtils.createXmlConfigApplicationContext((String)springConfigPath, (String[])activeProfiles);
        GrizzlyServer grizzlyServer = (GrizzlyServer)applicationContext.getBean(GrizzlyServer.class);
        if (shuttingDown) {
            ShutdownUtils.shutdownRemote((GrizzlyServerConfig)grizzlyServer.getConfig());
            log.warn("Shut down server at {}:{}", (Object)grizzlyServer.getConfig().getHostName(), (Object)grizzlyServer.getConfig().getShutdownPort());
            System.exit(0);
            return;
        }
        grizzlyServer.start();
    }
}

