/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.server.grizzly;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;
import org.tiogasolutions.notify.NotifyObjectMapper;
import org.tiogasolutions.notify.engine.web.NotifyApplication;
import org.tiogasolutions.notify.engine.web.readers.BundledStaticContentReader;
import org.tiogasolutions.notify.kernel.config.CouchEnvironment;
import org.tiogasolutions.notify.kernel.config.CouchServersConfig;
import org.tiogasolutions.notify.kernel.config.SystemConfiguration;
import org.tiogasolutions.notify.kernel.config.TrustedUserStore;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.task.TaskProcessorExecutor;
import org.tiogasolutions.notify.processor.logger.LoggerTaskProcessor;
import org.tiogasolutions.notify.processor.push.LivePushClientFactory;
import org.tiogasolutions.notify.processor.push.PushTaskProcessor;
import org.tiogasolutions.notify.processor.slack.SlackTaskProcessor;
import org.tiogasolutions.notify.processor.smtp.SmtpTaskProcessor;
import org.tiogasolutions.notify.processor.swing.SwingTaskProcessor;
import org.tiogasolutions.runners.grizzly.GrizzlyServer;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;

@Profile(value={"hosted"})
@Configuration
public class NotifyHostedSpringConfig {
    @Bean
    public LivePushClientFactory livePushClientFactory() {
        return new LivePushClientFactory();
    }

    @Bean
    public NotifyObjectMapper notifyObjectMapper() {
        return new NotifyObjectMapper();
    }

    @Bean
    public TiogaJacksonTranslator tiogaJacksonTranslator(NotifyObjectMapper objectMapper) {
        return new TiogaJacksonTranslator((ObjectMapper)objectMapper);
    }

    @Bean
    public TaskProcessorExecutor taskProcessorExecutor(DomainKernel domainKernel, EventBus eventBus, SwingTaskProcessor swingTaskProcessor, LoggerTaskProcessor loggerTaskProcessor, PushTaskProcessor pushTaskProcessor, SlackTaskProcessor slackTaskProcessor, SmtpTaskProcessor smtpTaskProcessor) {
        return new TaskProcessorExecutor(domainKernel, eventBus, Arrays.asList(swingTaskProcessor, loggerTaskProcessor, pushTaskProcessor, slackTaskProcessor, smtpTaskProcessor));
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.SystemConfiguration"})
    public SystemConfiguration systemConfiguration() {
        return new SystemConfiguration("*", "/api/v1/client", "/api/v1/admin");
    }

    @Bean(name={"org.tiogasolutions.notify.engine.web.readers.ExternalizedStaticContentReader"})
    BundledStaticContentReader bundledStaticContentReader() {
        return new BundledStaticContentReader("/org/tiogasolutions/notify/admin/app");
    }

    @Bean(name={"org.tiogasolutions.runners.grizzly.GrizzlyServerConfig"})
    public GrizzlyServerConfig grizzlyServerConfig() {
        GrizzlyServerConfig config = new GrizzlyServerConfig();
        config.setHostName(EnvUtils.findProperty((String)"notify.hostName", (String)"0.0.0.0"));
        config.setPort(Integer.valueOf(EnvUtils.findProperty((String)"notify.port", (String)"8080")).intValue());
        config.setShutdownPort(Integer.valueOf(EnvUtils.findProperty((String)"notify.shutdownPort", (String)"8081")).intValue());
        config.setContext(EnvUtils.findProperty((String)"notify.context", (String)""));
        config.setToOpenBrowser(false);
        return config;
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.CouchServersConfig"})
    public CouchServersConfig couchServersConfig() {
        CouchServersConfig config = new CouchServersConfig();
        config.setMasterUrl(EnvUtils.requireProperty((String)"notify.masterUrl"));
        config.setMasterUsername(EnvUtils.requireProperty((String)"notify.masterUsername"));
        config.setMasterPassword(EnvUtils.requireProperty((String)"notify.masterPassword"));
        config.setMasterDatabaseName(EnvUtils.requireProperty((String)"notify.masterDatabaseName"));
        config.setNotificationUrl(EnvUtils.requireProperty((String)"notify.notificationUrl"));
        config.setNotificationUsername(EnvUtils.requireProperty((String)"notify.notificationUsername"));
        config.setNotificationPassword(EnvUtils.requireProperty((String)"notify.notificationPassword"));
        config.setNotificationDatabasePrefix(EnvUtils.requireProperty((String)"notify.notificationDatabasePrefix"));
        config.setNotificationDatabaseSuffix(EnvUtils.requireProperty((String)"notify.notificationDatabaseSuffix"));
        config.setRequestUrl(EnvUtils.requireProperty((String)"notify.requestUrl"));
        config.setRequestUsername(EnvUtils.requireProperty((String)"notify.requestUsername"));
        config.setRequestPassword(EnvUtils.requireProperty((String)"notify.requestPassword"));
        config.setRequestDatabasePrefix(EnvUtils.requireProperty((String)"notify.requestDatabasePrefix"));
        config.setRequestDatabaseSuffix(EnvUtils.requireProperty((String)"notify.requestDatabaseSuffix"));
        return config;
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.TrustedUserStore"})
    public TrustedUserStore trustedUserStore() {
        return new TrustedUserStore("admin:password");
    }

    @Bean(name={"org.tiogasolutions.notify.kernel.config.CouchEnvironment"})
    public CouchEnvironment couchEnvironment() {
        return new CouchEnvironment().setTesting(false);
    }

    @Bean
    public NotifyApplication notifyApplication() {
        return new NotifyApplication();
    }

    @Bean
    public GrizzlyServer grizzlyServer(GrizzlyServerConfig grizzlyServerConfig, NotifyApplication application, ApplicationContext applicationContext) {
        ResourceConfig resourceConfig = ResourceConfig.forApplication((Application)application);
        resourceConfig.property("contextConfig", (Object)applicationContext);
        resourceConfig.packages(new String[]{"org.tiogasolutions.notify"});
        return new GrizzlyServer(grizzlyServerConfig, (Application)resourceConfig);
    }
}

