/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.jackson.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.HashMap;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfo;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;

public final class CouchAttachmentMetaMapDeserializer
extends StdDeserializer<CouchAttachmentInfoMap> {
    public CouchAttachmentMetaMapDeserializer() {
        super(CouchAttachmentInfoMap.class);
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer deserializer) throws IOException {
        return deserializer.deserializeTypedFromAny(parser, context);
    }

    public CouchAttachmentInfoMap deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        HashMap<String, CouchAttachmentInfo> attachmentMap = new HashMap<String, CouchAttachmentInfo>();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String attachmentName = parser.getCurrentName();
            parser.nextToken();
            CouchAttachmentInfo attachmentMeta = (CouchAttachmentInfo)parser.readValueAs(CouchAttachmentInfo.class);
            attachmentMap.put(attachmentName, attachmentMeta);
        }
        return new CouchAttachmentInfoMap(attachmentMap);
    }
}

