/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.pub.common;

import java.util.HashMap;
import java.util.Map;
import org.tiogasolutions.push.pub.common.Push;

public class PushType
implements Comparable<PushType> {
    private static Map<String, PushType> map = new HashMap<String, PushType>();
    private final String code;
    private final String label;
    private final Class<? extends Push> type;

    public static PushType find(String code) {
        if (!map.containsKey(code)) {
            String msg = String.format("The push type \"%s\" was not found.%n", code);
            throw new IllegalArgumentException(msg);
        }
        return map.get(code);
    }

    public PushType(String code) {
        PushType copy = PushType.find(code);
        this.code = copy.getCode();
        this.label = copy.getLabel();
        this.type = copy.getType();
    }

    public PushType(Class<? extends Push> type, String code, String label) {
        this.code = code;
        this.label = label;
        this.type = type;
        map.put(code, this);
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public Class<? extends Push> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushType pushType = (PushType)o;
        return this.code.equals(pushType.code);
    }

    public int hashCode() {
        int result = PushType.class.hashCode();
        result = 31 * result + this.code.hashCode();
        return result;
    }

    public String toString() {
        return this.code;
    }

    @Override
    public int compareTo(PushType that) {
        return this.code.compareTo(that.code);
    }
}

