/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.runners.grizzly;

import java.awt.Desktop;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Application;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.runners.grizzly.ShutdownHandler;
import org.tiogasolutions.runners.grizzly.ShutdownUtils;

public class GrizzlyServer {
    private static final Logger log = LoggerFactory.getLogger(GrizzlyServer.class);
    protected HttpServer httpServer;
    protected final ResourceConfig resourceConfig;
    protected final GrizzlyServerConfig serverConfig;

    public GrizzlyServer(GrizzlyServerConfig serverConfig, Application application) {
        this.serverConfig = serverConfig;
        this.resourceConfig = ResourceConfig.forApplication((Application)application);
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public GrizzlyServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public URI getBaseUri() {
        return this.serverConfig.getBaseUri();
    }

    public GrizzlyServerConfig getConfig() {
        return this.serverConfig;
    }

    public void start() {
        try {
            ShutdownUtils.shutdownRemote(this.serverConfig);
            this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.serverConfig.getBaseUri(), (ResourceConfig)this.resourceConfig);
            log.info("Application started at {}", (Object)this.getBaseUri());
            log.info("WADL available at {}application.wadl", (Object)this.getBaseUri());
            this.createShutdownHandler().start(this.httpServer);
            if (this.serverConfig.isToOpenBrowser()) {
                log.info("Opening web browser to {}", (Object)this.getBaseUri());
                URI baseUri = this.getBaseUri();
                Desktop.getDesktop().browse(baseUri);
            }
            Thread.currentThread().join();
        }
        catch (Throwable e) {
            log.error("Exception starting server", e);
            e.printStackTrace();
        }
    }

    protected ShutdownHandler createShutdownHandler() {
        return new ShutdownHandler(this.serverConfig);
    }

    public void shutdown() {
        if (this.httpServer != null) {
            this.httpServer.shutdown(30L, TimeUnit.SECONDS);
        }
    }

    public void register(Class type) {
        this.resourceConfig.register(type);
    }

    public void packages(String ... packages) {
        this.resourceConfig.packages(packages);
    }
}

